/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.infinispan;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;

@KeycloakIntegrationTest(config=ServerConfigWithCustomInfinispanXML.class)
public class InfinispanXMLBackwardCompatibilityTest {
    private static final String CONFIG_FILE = "/embedded-infinispan-config/infinispan-xml-kc26.xml";
    @InjectRealm
    ManagedRealm realm;

    @Test
    void testKeycloakStartedSuccessfullyWithOlderInfinispanXML() {
        RealmRepresentation representation = this.realm.admin().toRepresentation();
        Assertions.assertNotNull((Object)representation);
    }

    public static class ServerConfigWithCustomInfinispanXML
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.cacheConfigFile(InfinispanXMLBackwardCompatibilityTest.CONFIG_FILE);
        }
    }
}

