/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.welcomepage;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.config.Config;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.testframework.ui.page.WelcomePage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

@KeycloakIntegrationTest(config=WelcomePageTestConfig.class)
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class WelcomePageTest {
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    @InjectWebDriver
    WebDriver driver;
    @InjectAdminClient
    Keycloak adminClient;
    @InjectPage
    WelcomePage welcomePage;
    @InjectPage
    LoginPage loginPage;

    @Test
    @Order(value=1)
    public void localAccessNoAdminNorServiceAccount() {
        UsersResource users = this.adminClient.realms().realm("master").users();
        users.searchByUsername(Config.getAdminUsername(), Boolean.valueOf(true)).stream().findFirst().ifPresent(admin -> users.delete(admin.getId()));
        ClientsResource clients = this.adminClient.realms().realm("master").clients();
        clients.findByClientId(Config.getAdminClientId()).stream().findFirst().ifPresent(client -> clients.delete(client.getId()));
        this.welcomePage.navigateTo();
        Assertions.assertEquals((Object)"Create an administrative user", (Object)this.welcomePage.getWelcomeMessage());
        Assertions.assertTrue((boolean)this.welcomePage.getWelcomeDescription().startsWith("To get started with Keycloak, you first create an administrative user"));
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("form"));
    }

    @Test
    @Order(value=2)
    public void remoteAccessNoAdmin() throws Exception {
        this.driver.get(WelcomePageTest.getPublicServerUrl().toString());
        Assertions.assertEquals((Object)"Local access required", (Object)this.welcomePage.getWelcomeMessage());
        Assertions.assertTrue((boolean)this.welcomePage.getWelcomeDescription().startsWith("You will need local access to create the administrative user."));
        Assertions.assertFalse((boolean)this.driver.getPageSource().contains("form"));
    }

    @Test
    @Order(value=3)
    public void createAdminUser() {
        this.welcomePage.navigateTo();
        this.welcomePage.fillRegistration(Config.getAdminUsername(), Config.getAdminPassword());
        this.welcomePage.submit();
        Assertions.assertTrue((boolean)this.welcomePage.getPageAlert().contains("User created"));
        Assertions.assertTrue((boolean)((Boolean)this.runOnServer.fetch((FetchOnServer & Serializable)session -> new ApplianceBootstrap(session).createTemporaryMasterRealmAdminService(Config.getAdminClientId(), Config.getAdminClientSecret()), Boolean.class)));
        this.adminClient.tokenManager().refreshToken();
        List users = this.adminClient.realm("master").users().search(Config.getAdminUsername(), Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
    }

    @Test
    @Order(value=4)
    public void localAccessWithAdmin() {
        this.welcomePage.navigateTo();
        WelcomePageTest.assertOnAdminConsole(this.driver);
    }

    @Test
    @Order(value=5)
    public void remoteAccessWithAdmin() throws Exception {
        this.driver.get(WelcomePageTest.getPublicServerUrl().toString());
        WelcomePageTest.assertOnAdminConsole(this.driver);
    }

    @Test
    @Order(value=6)
    public void accessCreatedAdminAccount() throws MalformedURLException {
        this.welcomePage.navigateTo();
        if (this.driver.getClass().equals(HtmlUnitDriver.class)) {
            this.driver.navigate().to(this.getFakeLoginRedirect());
        }
        this.loginPage.fillLogin(Config.getAdminUsername(), Config.getAdminPassword());
        this.loginPage.submit();
        Assertions.assertEquals((Object)"Keycloak Administration Console", (Object)this.driver.getTitle());
    }

    private static String getFloatingIpAddress() throws Exception {
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface ni : Collections.list(netInterfaces)) {
            Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
            for (InetAddress a : Collections.list(inetAddresses)) {
                if (a.isLoopbackAddress() || !a.isSiteLocalAddress()) continue;
                return a.getHostAddress();
            }
        }
        return null;
    }

    static URL getPublicServerUrl() throws Exception {
        String floatingIp = WelcomePageTest.getFloatingIpAddress();
        if (floatingIp == null) {
            throw new RuntimeException("Could not determine floating IP address.");
        }
        return new URL("http", floatingIp, 8080, "");
    }

    static void assertOnAdminConsole(WebDriver driver) {
        new WebDriverWait(driver, Duration.ofSeconds(10L)).until(d -> driver.getTitle().equals("Keycloak Administration Console") || driver.getTitle().equals("Sign in to Keycloak"));
    }

    private URL getFakeLoginRedirect() throws MalformedURLException {
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)"http://localhost:8080/realms/master/protocol/openid-connect/auth");
        uriBuilder.queryParam("client_id", new Object[]{"security-admin-console"});
        uriBuilder.queryParam("redirect_uri", new Object[]{"http://localhost:8080/admin/master/console/"});
        uriBuilder.queryParam("state", new Object[]{"randomstate"});
        uriBuilder.queryParam("response_mode", new Object[]{"query"});
        uriBuilder.queryParam("response_type", new Object[]{"code"});
        uriBuilder.queryParam("scope", new Object[]{"openid"});
        uriBuilder.queryParam("nonce", new Object[]{"randomnonce"});
        uriBuilder.queryParam("code_challenge", new Object[]{"UV90ZNinyGsxyNlz6A08FQzDXbA7NCjkrCZv7PgeVxA"});
        uriBuilder.queryParam("code_challenge_method", new Object[]{"S256"});
        return uriBuilder.build(new Object[0]).toURL();
    }

    static class WelcomePageTestConfig
    implements KeycloakServerConfig {
        WelcomePageTestConfig() {
        }

        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config;
        }
    }
}

