/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.welcomepage;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.config.Config;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.WelcomePage;
import org.keycloak.tests.welcomepage.WelcomePageTest;
import org.openqa.selenium.WebDriver;

@KeycloakIntegrationTest(config=WelcomePageWithServiceAccountTestConfig.class)
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class WelcomePageWithServiceAccountTest {
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    @InjectWebDriver
    WebDriver driver;
    @InjectAdminClient
    Keycloak adminClient;
    @InjectPage
    WelcomePage welcomePage;

    @Test
    @Order(value=1)
    public void localAccessWithServiceAccount() {
        RealmResource masterRealm = this.adminClient.realms().realm("master");
        UsersResource users = masterRealm.users();
        masterRealm.users().searchByUsername(Config.getAdminUsername(), Boolean.valueOf(true)).stream().findFirst().ifPresent(admin -> users.delete(admin.getId()));
        this.welcomePage.navigateTo();
        WelcomePageTest.assertOnAdminConsole(this.driver);
    }

    @Test
    @Order(value=2)
    public void remoteAccessWithServiceAccount() throws Exception {
        this.driver.get(WelcomePageTest.getPublicServerUrl().toString());
        WelcomePageTest.assertOnAdminConsole(this.driver);
    }

    @Test
    @Order(value=3)
    public void createAdminUser() throws Exception {
        Assertions.assertFalse((boolean)((Boolean)this.runOnServer.fetch((FetchOnServer & Serializable)session -> new ApplianceBootstrap(session).createMasterRealmAdminUser(Config.getAdminUsername(), Config.getAdminPassword(), true, true), Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.runOnServer.fetch((FetchOnServer & Serializable)session -> new ApplianceBootstrap(session).createMasterRealmAdminUser(Config.getAdminUsername(), Config.getAdminPassword(), true, false), Boolean.class)));
    }

    static class WelcomePageWithServiceAccountTestConfig
    implements KeycloakServerConfig {
        WelcomePageWithServiceAccountTestConfig() {
        }

        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config;
        }
    }
}

