/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class DummyConfigurableRequiredActionFactory
implements RequiredActionFactory {
    public static final String PROVIDER_ID = "configurable-test-action";
    public static final String SETTING_1 = "setting1";
    public static final String SETTING_2 = "setting2";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = ProviderConfigurationBuilder.create().property().name("setting1").label("Setting 1").helpText("Setting 1 Help Text").type("String").defaultValue((Object)"setting1Default").add().property().name("setting2").label("Setting 2").helpText("Setting 2 Help Text").type("boolean").defaultValue((Object)"true").add().build();

    public String getDisplayText() {
        return "Configurable Test Action";
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return new RequiredActionProvider(){

            public void evaluateTriggers(RequiredActionContext context) {
            }

            public void requiredActionChallenge(RequiredActionContext context) {
                RequiredActionConfigModel configModel = context.getConfig();
                Map config = configModel.getConfig();
                String setting1Value = configModel.getConfigValue(DummyConfigurableRequiredActionFactory.SETTING_1);
                context.success();
            }

            public void processAction(RequiredActionContext context) {
            }

            public void close() {
            }
        };
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return Stream.concat(List.copyOf(CONFIG_PROPERTIES).stream(), List.copyOf(super.getConfigMetadata()).stream()).toList();
    }
}

