/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.utils.admin;

import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class ApiUtil {
    private static final Logger log = Logger.getLogger(ApiUtil.class);

    public static String getCreatedId(Response response) {
        Assertions.assertEquals((int)201, (int)response.getStatus());
        String path = response.getLocation().getPath();
        String createdId = path.substring(path.lastIndexOf(47) + 1);
        response.close();
        return createdId;
    }

    public static ClientResource findClientResourceById(RealmResource realm, String id) {
        for (ClientRepresentation c : realm.clients().findAll()) {
            if (!c.getId().equals(id)) continue;
            return realm.clients().get(c.getId());
        }
        return null;
    }

    public static ClientResource findClientResourceByClientId(RealmResource realm, String clientId) {
        for (ClientRepresentation c : realm.clients().findAll()) {
            if (!c.getClientId().equals(clientId)) continue;
            return realm.clients().get(c.getId());
        }
        return null;
    }

    public static ClientResource findClientResourceByName(RealmResource realm, String name) {
        for (ClientRepresentation c : realm.clients().findAll()) {
            if (!name.equals(c.getName())) continue;
            return realm.clients().get(c.getId());
        }
        return null;
    }

    public static ClientResource findClientByClientId(RealmResource realm, String clientId) {
        for (ClientRepresentation c : realm.clients().findAll()) {
            if (!clientId.equals(c.getClientId())) continue;
            return realm.clients().get(c.getId());
        }
        return null;
    }

    public static RoleResource findClientRoleByName(ClientResource client, String role) {
        return client.roles().get(role);
    }

    public static ProtocolMapperRepresentation findProtocolMapperByName(ClientResource client, String name) {
        for (ProtocolMapperRepresentation p : client.getProtocolMappers().getMappers()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static ProtocolMapperRepresentation findProtocolMapperByName(ClientScopeResource scope, String name) {
        for (ProtocolMapperRepresentation p : scope.getProtocolMappers().getMappers()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static ClientScopeResource findClientScopeByName(RealmResource realm, String clientScopeName) {
        for (ClientScopeRepresentation clientScope : realm.clientScopes().findAll()) {
            if (!clientScopeName.equals(clientScope.getName())) continue;
            return realm.clientScopes().get(clientScope.getId());
        }
        return null;
    }

    public static RoleResource findRealmRoleByName(RealmResource realm, String role) {
        return realm.roles().get(role);
    }

    public static UserRepresentation findUserByUsername(RealmResource realm, String username) {
        UserRepresentation user = null;
        List ur = realm.users().search(username, Boolean.valueOf(true));
        if (ur.size() == 1) {
            user = (UserRepresentation)ur.get(0);
        }
        if (ur.size() > 1) {
            for (UserRepresentation rep : ur) {
                if (!rep.getUsername().equalsIgnoreCase(username)) continue;
                return rep;
            }
        }
        return user;
    }

    public static UserResource findUserByUsernameId(RealmResource realm, String username) {
        return realm.users().get(ApiUtil.findUserByUsername(realm, username).getId());
    }

    public static String createUserWithAdminClient(RealmResource realm, UserRepresentation user) {
        Response response = realm.users().create(user);
        String createdId = ApiUtil.getCreatedId(response);
        response.close();
        return createdId;
    }

    public static String createUserAndResetPasswordWithAdminClient(RealmResource realm, UserRepresentation user, String password) {
        return ApiUtil.createUserAndResetPasswordWithAdminClient(realm, user, password, false);
    }

    public static String createUserAndResetPasswordWithAdminClient(RealmResource realm, UserRepresentation user, String password, boolean temporary) {
        String id = ApiUtil.createUserWithAdminClient(realm, user);
        ApiUtil.resetUserPassword(realm.users().get(id), password, temporary);
        return id;
    }

    public static void resetUserPassword(UserResource userResource, String newPassword, boolean temporary) {
        CredentialRepresentation newCredential = new CredentialRepresentation();
        newCredential.setType("password");
        newCredential.setValue(newPassword);
        newCredential.setTemporary(Boolean.valueOf(temporary));
        userResource.resetPassword(newCredential);
    }

    public static void assignRealmRoles(RealmResource realm, String userId, String ... roles) {
        String realmName = realm.toRepresentation().getRealm();
        ArrayList<RoleRepresentation> roleRepresentations = new ArrayList<RoleRepresentation>();
        for (String roleName : roles) {
            RoleRepresentation role = realm.roles().get(roleName).toRepresentation();
            roleRepresentations.add(role);
        }
        UserResource userResource = realm.users().get(userId);
        log.info((Object)("assigning roles " + Arrays.toString(roles) + " to user: \"" + userResource.toRepresentation().getUsername() + "\" in realm: \"" + realmName + "\""));
        userResource.roles().realmLevel().add(roleRepresentations);
    }

    public static void removeUserByUsername(RealmResource realmResource, String username) {
        UserRepresentation user = ApiUtil.findUserByUsername(realmResource, username);
        if (user != null) {
            realmResource.users().delete(user.getId());
        }
    }

    public static void assignClientRoles(RealmResource realm, String userId, String clientName, String ... roles) {
        String realmName = realm.toRepresentation().getRealm();
        String clientId = "";
        for (ClientRepresentation clientRepresentation : realm.clients().findAll()) {
            if (!clientRepresentation.getClientId().equals(clientName)) continue;
            clientId = clientRepresentation.getId();
        }
        if (!clientId.isEmpty()) {
            ClientResource clientResource = realm.clients().get(clientId);
            ArrayList<RoleRepresentation> roleRepresentations = new ArrayList<RoleRepresentation>();
            for (String roleName : roles) {
                RoleRepresentation role = clientResource.roles().get(roleName).toRepresentation();
                roleRepresentations.add(role);
            }
            UserResource userResource = realm.users().get(userId);
            log.info((Object)("assigning role: " + Arrays.toString(roles) + " to user: \"" + userResource.toRepresentation().getUsername() + "\" of client: \"" + clientName + "\" in realm: \"" + realmName + "\""));
            userResource.roles().clientLevel(clientId).add(roleRepresentations);
        } else {
            log.warn((Object)("client with name " + clientName + " doesn't exist in realm " + realmName));
        }
    }

    public static boolean groupContainsSubgroup(GroupResource groupsResource, GroupRepresentation subgroup) {
        boolean contains = false;
        for (GroupRepresentation sg : groupsResource.getSubGroups(null, null, Boolean.valueOf(true))) {
            if (!subgroup.getId().equals(sg.getId())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static AuthorizationResource findAuthorizationSettings(RealmResource realm, String clientId) {
        for (ClientRepresentation c : realm.clients().findAll()) {
            if (!c.getClientId().equals(clientId)) continue;
            return realm.clients().get(c.getId()).authorization();
        }
        return null;
    }

    public static void updateRequiredActionsOrder(RealmResource realmResource, List<UserModel.RequiredAction> requiredActionsInTargetOrder) {
        ApiUtil.updateRequiredActionsOrderByAlias(realmResource, requiredActionsInTargetOrder.stream().map(Enum::name).collect(Collectors.toList()));
    }

    public static void updateRequiredActionsOrderByAlias(RealmResource realmResource, List<String> requiredActionsInTargetOrder) {
        String realmName = realmResource.toRepresentation().getRealm();
        List initialRequiredActionsOrdered = realmResource.flows().getRequiredActions().stream().map(RequiredActionProviderRepresentation::getAlias).collect(Collectors.toList());
        log.infof("initial required actions order for realm '%s': %s", (Object)realmName, initialRequiredActionsOrdered);
        log.infof("target order for realm '%s' (maybe partial): %s", (Object)realmName, requiredActionsInTargetOrder);
        ArrayList<String> requiredActionsToConfigureWithLowerPrio = new ArrayList<String>(requiredActionsInTargetOrder);
        for (String requiredActionAlias : requiredActionsInTargetOrder) {
            List allRequiredActionsOrdered = realmResource.flows().getRequiredActions().stream().map(RequiredActionProviderRepresentation::getAlias).collect(Collectors.toList());
            requiredActionsToConfigureWithLowerPrio.remove(requiredActionAlias);
            int currentIndex = allRequiredActionsOrdered.indexOf(requiredActionAlias);
            if (currentIndex == -1) {
                throw new IllegalStateException("Required action not found: " + requiredActionAlias);
            }
            Optional<String> aliasOfCurrentlyFirstActionWithLowerTargetPrioOpt = allRequiredActionsOrdered.stream().filter(requiredActionsToConfigureWithLowerPrio::contains).findFirst();
            aliasOfCurrentlyFirstActionWithLowerTargetPrioOpt.ifPresent(aliasOfCurrentlyFirstActionWithLowerTargetPrio -> {
                int indexOfCurrentlyFirstActionWithLowerTargetPrio = allRequiredActionsOrdered.indexOf(aliasOfCurrentlyFirstActionWithLowerTargetPrio);
                int positionsToMoveCurrentActionUp = Math.max(currentIndex - indexOfCurrentlyFirstActionWithLowerTargetPrio, 0);
                if (positionsToMoveCurrentActionUp > 0) {
                    for (int i = 0; i < positionsToMoveCurrentActionUp; ++i) {
                        realmResource.flows().raiseRequiredActionPriority(requiredActionAlias);
                    }
                }
            });
        }
        List updatedRequiredActionsOrdered = realmResource.flows().getRequiredActions().stream().map(RequiredActionProviderRepresentation::getAlias).collect(Collectors.toList());
        log.infof("updated required actions order for realm '%s': %s", (Object)realmName, updatedRequiredActionsOrdered);
    }
}

