/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.utils;

import jakarta.ws.rs.core.Response;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.junit.jupiter.api.Assertions;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractEcKeyProviderFactory;
import org.keycloak.keys.GeneratedEcdhKeyProviderFactory;
import org.keycloak.keys.GeneratedEcdsaKeyProviderFactory;
import org.keycloak.keys.KeyProvider;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.tests.utils.admin.ApiUtil;

public class KeyUtils {
    public static KeyPair generateECKey(String algorithm) {
        try {
            KeyPairGenerator kpg = CryptoIntegration.getProvider().getKeyPairGen("ECDSA");
            String domainParamNistRep = GeneratedEcdsaKeyProviderFactory.convertJWSAlgorithmToECDomainParmNistRep((String)algorithm);
            if (domainParamNistRep == null) {
                domainParamNistRep = GeneratedEcdhKeyProviderFactory.convertJWEAlgorithmToECDomainParmNistRep((String)algorithm);
            }
            String curve = AbstractEcKeyProviderFactory.convertECDomainParmNistRepToSecRep((String)domainParamNistRep);
            ECGenParameterSpec parameterSpec = new ECGenParameterSpec(curve);
            kpg.initialize(parameterSpec);
            return kpg.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair generateEdDSAKey(String curve) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator kpg = CryptoIntegration.getProvider().getKeyPairGen(curve);
        return kpg.generateKeyPair();
    }

    public static SecretKey generateSecretKey(String algorithm, int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator keyGen = KeyGenerator.getInstance(JavaAlgorithm.getJavaAlgorithm((String)algorithm), BouncyIntegration.PROVIDER);
        keyGen.init(keySize);
        return keyGen.generateKey();
    }

    public static PublicKey publicKeyFromString(String key) {
        try {
            KeyFactory kf = CryptoIntegration.getProvider().getKeyFactory("RSA");
            byte[] encoded = Base64.getDecoder().decode(key);
            return kf.generatePublic(new X509EncodedKeySpec(encoded));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey privateKeyFromString(String key) {
        try {
            KeyFactory kf = CryptoIntegration.getProvider().getKeyFactory("RSA");
            byte[] encoded = Base64.getDecoder().decode(key);
            return kf.generatePrivate(new PKCS8EncodedKeySpec(encoded));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeysMetadataRepresentation.KeyMetadataRepresentation getActiveEncryptionKey(KeysMetadataRepresentation keys, String algorithm) {
        for (KeysMetadataRepresentation.KeyMetadataRepresentation k : keys.getKeys()) {
            if (!k.getAlgorithm().equals(algorithm) || !KeyStatus.valueOf((String)k.getStatus()).isActive() || !KeyUse.ENC.equals((Object)k.getUse())) continue;
            return k;
        }
        throw new RuntimeException("Active key not found");
    }

    public static KeysMetadataRepresentation.KeyMetadataRepresentation findActiveSigningKey(RealmResource realm) {
        return KeyUtils.findRealmKeys(realm, rep -> rep.getPublicKey() != null && KeyStatus.valueOf((String)rep.getStatus()).isActive() && KeyUse.SIG.equals((Object)rep.getUse())).findFirst().orElse(null);
    }

    public static KeysMetadataRepresentation.KeyMetadataRepresentation findActiveSigningKey(RealmResource realm, String alg) {
        return KeyUtils.findRealmKeys(realm, rep -> rep.getPublicKey() != null && KeyStatus.valueOf((String)rep.getStatus()).isActive() && KeyUse.SIG.equals((Object)rep.getUse()) && alg.equals(rep.getAlgorithm())).findFirst().orElse(null);
    }

    public static KeysMetadataRepresentation.KeyMetadataRepresentation findActiveEncryptingKey(RealmResource realm, String alg) {
        return KeyUtils.findRealmKeys(realm, rep -> rep.getPublicKey() != null && KeyStatus.valueOf((String)rep.getStatus()).isActive() && KeyUse.ENC.equals((Object)rep.getUse()) && alg.equals(rep.getAlgorithm())).findFirst().orElse(null);
    }

    public static Stream<KeysMetadataRepresentation.KeyMetadataRepresentation> findRealmKeys(RealmResource realm, Predicate<KeysMetadataRepresentation.KeyMetadataRepresentation> filter) {
        return realm.keys().getKeyMetadata().getKeys().stream().filter(filter);
    }

    public static AutoCloseable generateNewRealmKey(RealmResource realm, KeyUse keyUse, String algorithm, String priority) {
        String realmId = realm.toRepresentation().getId();
        ComponentRepresentation keys = new ComponentRepresentation();
        keys.setName("generated");
        keys.setProviderType(KeyProvider.class.getName());
        keys.setProviderId(keyUse == KeyUse.ENC ? "rsa-enc-generated" : "rsa-generated");
        keys.setParentId(realmId);
        keys.setConfig(new MultivaluedHashMap());
        keys.getConfig().putSingle((Object)"priority", (Object)priority);
        keys.getConfig().putSingle((Object)"keyUse", (Object)KeyUse.ENC.getSpecName());
        keys.getConfig().putSingle((Object)"algorithm", (Object)algorithm);
        Response response = realm.components().add(keys);
        Assertions.assertEquals((int)201, (int)response.getStatus());
        String id = ApiUtil.getCreatedId(response);
        response.close();
        return () -> realm.components().removeComponent(id);
    }

    public static AutoCloseable generateNewRealmKey(RealmResource realm, KeyUse keyUse, String algorithm) {
        return KeyUtils.generateNewRealmKey(realm, keyUse, algorithm, "100");
    }

    public static String[] getExpectedSupportedRsaKeySizes() {
        String expectedKeySizes = System.getProperty("auth.server.supported.rsa.key.sizes");
        if (expectedKeySizes == null || expectedKeySizes.trim().isEmpty()) {
            Assertions.fail((String)"System property 'auth.server.supported.rsa.key.sizes' should be set");
        }
        return expectedKeySizes.split(",");
    }

    public static int getLowestSupportedRsaKeySize() {
        return Integer.parseInt(KeyUtils.getExpectedSupportedRsaKeySizes()[0]);
    }
}

