/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.api.sym;

import org.keymg.api.sym.exceptions.SymKeyGenerationException;
import org.keymg.core.sym.SymKeyProcessor;
import org.keymg.core.sym.config.KeymgConfigurationManager;
import org.keymg.core.sym.policy.SymKeyPolicyStore;
import org.keymg.core.sym.util.DocumentUtil;
import org.keymg.sym.model.ekmi.SymkeyResponse;
import org.keymg.sym.model.ekmi.ValidResponseType;
import org.w3c.dom.Document;

public class KeyGenerator {
    private KeymgConfigurationManager configurationManager = KeymgConfigurationManager.getInstance();
    protected String serverID = null;
    protected SymKeyPolicyStore policyStore = null;

    public String getServerID() {
        return this.serverID;
    }

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    public SymKeyPolicyStore getPolicyStore() {
        return this.policyStore;
    }

    public void setPolicyStore(SymKeyPolicyStore policyStore) {
        this.policyStore = policyStore;
        KeymgConfigurationManager.setPolicyStore((SymKeyPolicyStore)policyStore);
    }

    public Document generate(String keyID) throws SymKeyGenerationException {
        if (keyID == null) {
            throw new IllegalArgumentException("keyID is null");
        }
        if (this.serverID == null) {
            throw new IllegalArgumentException("serverID is null");
        }
        if (this.policyStore == null) {
            throw new IllegalArgumentException("policyStore is null");
        }
        SymKeyProcessor processor = new SymKeyProcessor((SymKeyPolicyStore)this.configurationManager);
        processor.setServerID(this.serverID);
        ValidResponseType validResponseType = processor.generate(keyID);
        SymkeyResponse response = new SymkeyResponse();
        response.add(validResponseType);
        try {
            return DocumentUtil.create((String)response.toString());
        }
        catch (Exception e) {
            throw new SymKeyGenerationException(e);
        }
    }
}

