/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.api.sym.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.keymg.api.sym.exceptions.SymKeyGenerationException;
import org.keymg.core.sym.Base64;
import org.keymg.core.sym.generators.SymKeyGenerator;
import org.keymg.core.sym.parse.Parser;
import org.keymg.core.sym.writers.SymkeyWriter;
import org.keymg.sym.model.ekmi.SymkeyRequest;
import org.keymg.sym.model.ekmi.SymkeyResponse;
import org.keymg.sym.model.ekmi.SymkeyType;

public class SymKeyClient {
    protected String serverURL;
    protected String domainID;
    private PrivateKey privateKey;

    public SymKeyClient(String domainID, String serverURL, PrivateKey privateKey) {
        this.domainID = domainID;
        this.serverURL = serverURL;
        this.privateKey = privateKey;
    }

    public SymkeyResponse createNew() throws SymKeyGenerationException {
        try {
            SymkeyRequest request = new SymkeyRequest();
            request.addGlobalKeyID(this.newGID());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            SymkeyWriter writer = new SymkeyWriter((OutputStream)bos);
            writer.write(request);
            byte[] bytes = bos.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            DefaultHttpClient client = new DefaultHttpClient();
            BasicHttpContext localContext = new BasicHttpContext();
            InputStreamEntity isEntity = new InputStreamEntity((InputStream)is, (long)bytes.length);
            HttpPost post = new HttpPost(this.serverURL);
            post.setEntity((HttpEntity)isEntity);
            HttpResponse httpResponse = client.execute((HttpUriRequest)post, (HttpContext)localContext);
            InputStream responseStream = httpResponse.getEntity().getContent();
            Parser parser = new Parser();
            parser.parse(responseStream);
            return (SymkeyResponse)parser.getParsedObject();
        }
        catch (Exception e) {
            throw new SymKeyGenerationException(e);
        }
    }

    public byte[] getKey(SymkeyResponse response) throws IOException, GeneralSecurityException, UnsupportedEncodingException {
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (this.privateKey == null) {
            throw new IllegalStateException("Private Key has not been set");
        }
        SymkeyType key = (SymkeyType)response.getResponse().get(0);
        String encryptedValue = key.getCipherData().getCipherValue();
        byte[] encryptedBytes = Base64.decode((byte[])encryptedValue.getBytes("UTF-8"));
        SymKeyGenerator gen = new SymKeyGenerator();
        return gen.decrypt(encryptedBytes, (Key)this.privateKey);
    }

    protected String newGID() {
        StringBuilder builder = new StringBuilder(this.domainID);
        builder.append("-0-0");
        return builder.toString();
    }
}

