/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keymg.core.sym.parse.ParserUtil;
import org.keymg.core.sym.parse.XMLParser;
import org.keymg.sym.model.ekmi.KeyCacheDetailType;
import org.keymg.sym.model.ekmi.KeyCachePolicyType;
import org.keymg.sym.model.ekmi.KeyClassType;
import org.keymg.sym.model.ekmi.NonNegativeInteger;
import org.keymg.sym.model.ekmi.StatusType;
import org.keymg.sym.model.ekmi.TwoPartIDType;

public class KeyCachePolicyParser
implements XMLParser {
    private static Logger log = Logger.getLogger(KeyCachePolicyParser.class.getCanonicalName());

    public boolean acceptsQName(QName qname) {
        return false;
    }

    public QName[] getQNames() {
        return null;
    }

    public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        KeyCachePolicyType keyCachePolicyType = (KeyCachePolicyType)populateObject;
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        KeyCacheDetailType kcd;
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if ("KeyCachePolicyID".equals(localPart)) {
                            keyCachePolicyType.setKeyCachePolicyID(new TwoPartIDType(xmlEventReader.getElementText()));
                            break;
                        }
                        if ("PolicyName".equals(localPart)) {
                            keyCachePolicyType.setPolicyName(xmlEventReader.getElementText());
                            break;
                        }
                        if ("Description".equals(localPart)) {
                            keyCachePolicyType.setDescription(xmlEventReader.getElementText());
                            break;
                        }
                        if ("KeyClass".equals(localPart)) {
                            String str = xmlEventReader.getElementText();
                            keyCachePolicyType.setKeyClassType(new KeyClassType(str));
                            break;
                        }
                        if ("StartDate".equals(localPart)) {
                            String startDateStr = xmlEventReader.getElementText();
                            Date startDate = null;
                            try {
                                startDate = ParserUtil.parseDate(startDateStr);
                            }
                            catch (ParseException e) {
                                throw new RuntimeException(e);
                            }
                            keyCachePolicyType.setStartDate(startDate);
                            break;
                        }
                        if ("EndDate".equals(localPart)) {
                            String endDateStr = xmlEventReader.getElementText();
                            Date endDate = null;
                            try {
                                endDate = ParserUtil.parseDate(endDateStr);
                            }
                            catch (ParseException e) {
                                throw new RuntimeException(e);
                            }
                            keyCachePolicyType.setEndDate(endDate);
                            break;
                        }
                        if ("PolicyCheckInterval".equals(localPart)) {
                            Integer val = Integer.valueOf(xmlEventReader.getElementText());
                            keyCachePolicyType.setPolicyCheckInterval(new NonNegativeInteger(val));
                            break;
                        }
                        if ("Status".equals(localPart)) {
                            String statusStr = xmlEventReader.getElementText();
                            keyCachePolicyType.setStatus(StatusType.fromValue((String)statusStr));
                            break;
                        }
                        if ("NewKeysCacheDetail".equals(localPart)) {
                            kcd = new KeyCacheDetailType();
                            this.parseCacheDetail(xmlEventReader, kcd);
                            keyCachePolicyType.setNewKeysCacheDetail(kcd);
                            break;
                        }
                        if (!"UsedKeysCacheDetail".equals(localPart)) break;
                        kcd = new KeyCacheDetailType();
                        this.parseCacheDetail(xmlEventReader, kcd);
                        keyCachePolicyType.setUsedKeysCacheDetail(kcd);
                        break;
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("KeyCachePolicy")) break;
                        return;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
    }

    protected void parseCacheDetail(XMLEventReader xmlEventReader, KeyCacheDetailType kcd) throws XMLStreamException {
        while (xmlEventReader.hasNext()) {
            XMLEvent ev = xmlEventReader.nextEvent();
            switch (ev.getEventType()) {
                case 1: {
                    String str;
                    StartElement nextStartElement = (StartElement)ev;
                    QName elementName = nextStartElement.getName();
                    String localPart = elementName.getLocalPart();
                    if ("MaximumKeys".equals(localPart)) {
                        str = xmlEventReader.getElementText();
                        kcd.setMaximumKeys(BigInteger.valueOf(Long.valueOf(str)));
                        break;
                    }
                    if (!"MaximumDuration".equals(localPart)) break;
                    str = xmlEventReader.getElementText();
                    kcd.setMaximumDuration(BigInteger.valueOf(Long.valueOf(str)));
                    break;
                }
                case 2: {
                    EndElement endElement = (EndElement)ev;
                    String localPart = endElement.getName().getLocalPart();
                    if (!localPart.equals("NewKeysCacheDetail") && !localPart.equals("UsedKeysCacheDetail")) break;
                    return;
                }
                case 8: {
                    return;
                }
            }
        }
    }
}

