/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import org.keymg.core.sym.parse.KeyCachePolicyRequestParser;
import org.keymg.core.sym.parse.KeyCachePolicyResponseParser;
import org.keymg.core.sym.parse.ParserFactory;
import org.keymg.core.sym.parse.SymkeyParser;
import org.keymg.core.sym.parse.SymkeyRequestParser;
import org.keymg.core.sym.parse.SymkeyResponseParser;
import org.keymg.sym.model.ekmi.KeyCachePolicyRequestType;
import org.keymg.sym.model.ekmi.KeyCachePolicyResponseType;
import org.keymg.sym.model.ekmi.SymkeyRequest;
import org.keymg.sym.model.ekmi.SymkeyResponse;

public class Parser {
    private Object parsedObject;

    public Parser() {
        ParserFactory.addXMLParser(new SymkeyParser());
    }

    public void parse(Source source) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(source);
        this.parseNow(xmlEventReader);
    }

    public void parse(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(inputStream);
        this.parseNow(xmlEventReader);
    }

    public Object getParsedObject() {
        return this.parsedObject;
    }

    private void parseNow(XMLEventReader xmlEventReader) throws XMLStreamException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (!(xmlEvent instanceof StartElement)) continue;
            StartElement startElement = (StartElement)xmlEvent;
            this.handleStartElement(xmlEventReader, startElement);
        }
    }

    private void handleStartElement(XMLEventReader xmlEventReader, StartElement startElement) throws XMLStreamException {
        QName elementName = startElement.getName();
        String namespace = elementName.getNamespaceURI();
        String localPart = elementName.getLocalPart();
        if (namespace == null) {
            throw new IllegalStateException("Namespace is null");
        }
        if ("SymkeyRequest".equals(localPart)) {
            this.parsedObject = new SymkeyRequest();
            SymkeyRequestParser symKeyRequestParser = new SymkeyRequestParser();
            symKeyRequestParser.handle(xmlEventReader, startElement, this.parsedObject);
        } else if ("SymkeyResponse".equals(localPart)) {
            this.parsedObject = new SymkeyResponse();
            SymkeyResponseParser symKeyResponseParser = new SymkeyResponseParser();
            symKeyResponseParser.handle(xmlEventReader, startElement, this.parsedObject);
        } else if ("KeyCachePolicyRequest".equals(localPart)) {
            this.parsedObject = new KeyCachePolicyRequestType();
            KeyCachePolicyRequestParser kcpParser = new KeyCachePolicyRequestParser();
            kcpParser.handle(xmlEventReader, startElement, this.parsedObject);
        } else if ("KeyCachePolicyResponse".equals(localPart)) {
            this.parsedObject = new KeyCachePolicyResponseType();
            KeyCachePolicyResponseParser kcpParser = new KeyCachePolicyResponseParser();
            kcpParser.handle(xmlEventReader, startElement, this.parsedObject);
        } else {
            throw new RuntimeException("Unknown: " + localPart);
        }
    }
}

