/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keymg.core.sym.parse.XMLParser;
import org.keymg.sym.model.ekmi.ApplicationsType;

public class PermittedApplicationParser
implements XMLParser {
    private static Logger log = Logger.getLogger(PermittedApplicationParser.class.getCanonicalName());

    public boolean acceptsQName(QName qname) {
        return false;
    }

    public QName[] getQNames() {
        return null;
    }

    public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        ApplicationsType applicationType = (ApplicationsType)populateObject;
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if ("ApplicationID".equals(localPart)) {
                            String applicationID = xmlEventReader.getElementText().trim();
                            applicationType.setApplicationID(applicationID);
                            break;
                        }
                        if ("ApplicationName".equals(localPart)) {
                            String applicationName = xmlEventReader.getElementText().trim();
                            applicationType.setApplicationName(applicationName);
                            break;
                        }
                        if ("ApplicationVersion".equals(localPart)) {
                            String applicationVersion = xmlEventReader.getElementText().trim();
                            applicationType.setVersion(applicationVersion);
                            break;
                        }
                        if ("ApplicationDigestAlgorithm".equals(localPart)) {
                            String appDigestAlgorithm = xmlEventReader.getElementText().trim();
                            applicationType.setDigestAlgorithm(appDigestAlgorithm);
                            break;
                        }
                        if (!"ApplicationDigestValue".equals(localPart)) break;
                        String appDigestValue = xmlEventReader.getElementText().trim();
                        applicationType.setDigestValue(appDigestValue.getBytes("UTF-8"));
                        break;
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("PermittedApplication")) break;
                        return;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
    }
}

