/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keymg.core.sym.parse.ParserUtil;
import org.keymg.core.sym.parse.XMLParser;
import org.keymg.sym.model.ekmi.PermittedDatesType;

public class PermittedDatesParser
implements XMLParser {
    private static Logger log = Logger.getLogger(PermittedDatesParser.class.getCanonicalName());

    public boolean acceptsQName(QName qname) {
        return false;
    }

    public QName[] getQNames() {
        return null;
    }

    public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        PermittedDatesType permittedDatesType = (PermittedDatesType)populateObject;
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if (!"PermittedDate".equals(localPart)) break;
                        PermittedDateParser permittedDateParser = new PermittedDateParser();
                        permittedDateParser.handle(xmlEventReader, xmlEvent, permittedDatesType);
                        break;
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("PermittedDates")) break;
                        return;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
    }

    private static class PermittedDateParser
    implements XMLParser {
        private PermittedDateParser() {
        }

        public boolean acceptsQName(QName qname) {
            return false;
        }

        public QName[] getQNames() {
            return null;
        }

        public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
            try {
                PermittedDatesType permittedDatesType = (PermittedDatesType)populateObject;
                PermittedDatesType.PermittedDate permittedDate = new PermittedDatesType.PermittedDate();
                permittedDatesType.addPermittedDate(permittedDate);
                while (xmlEventReader.hasNext()) {
                    XMLEvent ev = xmlEventReader.nextEvent();
                    switch (ev.getEventType()) {
                        case 1: {
                            StartElement nextStartElement = (StartElement)ev;
                            QName elementName = nextStartElement.getName();
                            String localPart = elementName.getLocalPart();
                            if ("StartDate".equals(localPart)) {
                                String startDateStr = xmlEventReader.getElementText();
                                Date startDate = ParserUtil.parseDate(startDateStr);
                                permittedDate.setStartDate(startDate);
                                break;
                            }
                            if (!"EndDate".equals(localPart)) break;
                            String endDateStr = xmlEventReader.getElementText();
                            Date endDate = ParserUtil.parseDate(endDateStr);
                            permittedDate.setEndDate(endDate);
                            break;
                        }
                        case 2: {
                            EndElement endElement = (EndElement)ev;
                            String localPart = endElement.getName().getLocalPart();
                            if (!localPart.equals("PermittedDate")) break;
                            return;
                        }
                        case 8: {
                            return;
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                log.log(Level.SEVERE, "Unable to parse:", e);
            }
            catch (ParseException e) {
                log.log(Level.SEVERE, "Unable to parse:", e);
            }
        }
    }
}

