/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keymg.core.sym.parse.ParserUtil;
import org.keymg.core.sym.parse.XMLParser;
import org.keymg.sym.model.ekmi.PermittedTimesType;

public class PermittedTimesParser
implements XMLParser {
    private static Logger log = Logger.getLogger(PermittedTimesParser.class.getCanonicalName());

    public boolean acceptsQName(QName qname) {
        return false;
    }

    public QName[] getQNames() {
        return null;
    }

    public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        PermittedTimesType permittedTimesType = (PermittedTimesType)populateObject;
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if (!"PermittedTime".equals(localPart)) break;
                        PermittedTimeParser permittedTimeParser = new PermittedTimeParser();
                        permittedTimeParser.handle(xmlEventReader, xmlEvent, permittedTimesType);
                        break;
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("PermittedTimes")) break;
                        return;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
    }

    private static class PermittedTimeParser
    implements XMLParser {
        private PermittedTimeParser() {
        }

        public boolean acceptsQName(QName qname) {
            return false;
        }

        public QName[] getQNames() {
            return null;
        }

        public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
            try {
                PermittedTimesType permittedTimesType = (PermittedTimesType)populateObject;
                PermittedTimesType.PermittedTime permittedTime = new PermittedTimesType.PermittedTime();
                permittedTimesType.addPermittedTime(permittedTime);
                while (xmlEventReader.hasNext()) {
                    XMLEvent ev = xmlEventReader.nextEvent();
                    switch (ev.getEventType()) {
                        case 1: {
                            StartElement nextStartElement = (StartElement)ev;
                            QName elementName = nextStartElement.getName();
                            String localPart = elementName.getLocalPart();
                            if ("StartTime".equals(localPart)) {
                                String startDateStr = xmlEventReader.getElementText();
                                Date startDate = ParserUtil.parseTime(startDateStr);
                                permittedTime.setStartTime(startDate);
                                break;
                            }
                            if (!"EndTime".equals(localPart)) break;
                            String endDateStr = xmlEventReader.getElementText();
                            Date endDate = ParserUtil.parseTime(endDateStr);
                            permittedTime.setEndTime(endDate);
                            break;
                        }
                        case 2: {
                            EndElement endElement = (EndElement)ev;
                            String localPart = endElement.getName().getLocalPart();
                            if (!localPart.equals("PermittedTime")) break;
                            return;
                        }
                        case 8: {
                            return;
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                log.log(Level.SEVERE, "Unable to parse:", e);
            }
            catch (ParseException e) {
                log.log(Level.SEVERE, "Unable to parse:", e);
            }
        }
    }
}

