/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keymg.core.sym.parse.XMLParser;
import org.keymg.sym.model.ekmi.KeyClassType;
import org.keymg.sym.model.ekmi.KeyClassesType;
import org.keymg.sym.model.ekmi.SymkeyRequest;

public class SymkeyRequestParser
implements XMLParser {
    private static Logger log = Logger.getLogger(SymkeyRequestParser.class.getCanonicalName());

    public boolean acceptsQName(QName qname) {
        return false;
    }

    public QName[] getQNames() {
        return null;
    }

    public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        SymkeyRequest symKeyRequest = (SymkeyRequest)populateObject;
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if (localPart.equals("GlobalKeyID")) {
                            String gid = xmlEventReader.getElementText();
                            symKeyRequest.addGlobalKeyID(gid);
                            break;
                        }
                        if (localPart.equals("KeyClasses")) {
                            KeyClassesParser keyClassesParser = new KeyClassesParser();
                            keyClassesParser.handle(xmlEventReader, nextStartElement, symKeyRequest);
                            break;
                        }
                        if (localPart.equals("X509EncryptionCertificate")) {
                            String cert = xmlEventReader.getElementText().trim();
                            symKeyRequest.setX509EncryptionCertificate(cert.getBytes());
                            break;
                        }
                        if ("SymkeyRequestID".equals(localPart)) {
                            String requestID = xmlEventReader.getElementText().trim();
                            symKeyRequest.addSymkeyRequestID(requestID);
                            break;
                        }
                        throw new RuntimeException("Unknown element:" + localPart);
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("SymkeyRequest")) break;
                        return;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
    }

    private static class KeyClassesParser
    implements XMLParser {
        private KeyClassesParser() {
        }

        public boolean acceptsQName(QName qname) {
            return false;
        }

        public QName[] getQNames() {
            return null;
        }

        public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
            SymkeyRequest symKeyRequest = (SymkeyRequest)populateObject;
            KeyClassesType keyClassesType = new KeyClassesType();
            symKeyRequest.setKeyClasses(keyClassesType);
            try {
                while (xmlEventReader.hasNext()) {
                    XMLEvent ev = xmlEventReader.nextEvent();
                    switch (ev.getEventType()) {
                        case 1: {
                            StartElement nextStartElement = (StartElement)ev;
                            QName elementName = nextStartElement.getName();
                            String localPart = elementName.getLocalPart();
                            if (!localPart.equals("KeyClass")) break;
                            String gid = xmlEventReader.getElementText();
                            KeyClassType keyClassType = new KeyClassType(gid);
                            keyClassesType.add(keyClassType);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 8: {
                            return;
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }
}

