/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keymg.core.sym.parse.ParserFactory;
import org.keymg.core.sym.parse.XMLParser;
import org.keymg.sym.model.ekmi.SymkeyResponse;

public class SymkeyResponseParser
implements XMLParser {
    private static Logger log = Logger.getLogger(SymkeyResponseParser.class.getCanonicalName());

    public boolean acceptsQName(QName qname) {
        return false;
    }

    public QName[] getQNames() {
        return null;
    }

    public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        SymkeyResponse symKeyResponse = (SymkeyResponse)populateObject;
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String nsURI = elementName.getNamespaceURI();
                        XMLParser xmlParser = ParserFactory.getParser(elementName);
                        if (xmlParser == null) {
                            log.log(Level.SEVERE, "Unable to locate any parser for the namespace:" + nsURI);
                            break;
                        }
                        xmlParser.handle(xmlEventReader, nextStartElement, symKeyResponse);
                        break;
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("SymkeyResponse")) break;
                        return;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
    }
}

