/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.pki;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.keymg.core.sym.pki.PKIManager;
import org.keymg.core.sym.pki.PKIRepositoryException;

public class KeyStorePKIManager
implements PKIManager {
    private File keyStoreFile;
    private KeyStore keyStore;
    private char[] keyStorePassword;
    public static String KEYSTORE_TYPE = "JCEKS";

    public KeyStorePKIManager(File keyStoreFile, char[] keyPass) throws PKIRepositoryException {
        this.keyStoreFile = keyStoreFile;
        try {
            this.keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            FileInputStream in = new FileInputStream(keyStoreFile);
            this.keyStore.load(in, keyPass);
            in.close();
        }
        catch (Exception e) {
            throw new PKIRepositoryException(e);
        }
        this.keyStorePassword = keyPass;
    }

    public PublicKey getPublicKey(String domainID) throws PKIRepositoryException {
        PublicKey publicKey = null;
        try {
            Certificate cert = this.keyStore.getCertificate(domainID);
            if (cert != null) {
                publicKey = cert.getPublicKey();
            }
        }
        catch (KeyStoreException e) {
            throw new PKIRepositoryException(e);
        }
        return publicKey;
    }

    public void register(String domainID, Certificate cert) throws PKIRepositoryException {
        try {
            this.keyStore.setCertificateEntry(domainID, cert);
            FileOutputStream out = new FileOutputStream(this.keyStoreFile);
            this.keyStore.store(out, this.keyStorePassword);
            out.close();
        }
        catch (Exception e) {
            throw new PKIRepositoryException(e);
        }
    }

    public KeyPair getKeyPair(String domainID) throws PKIRepositoryException {
        try {
            Key key = this.keyStore.getKey(domainID, this.keyStorePassword);
            if (key instanceof PrivateKey) {
                Certificate cert = this.keyStore.getCertificate(domainID);
                PublicKey publicKey = cert.getPublicKey();
                return new KeyPair(publicKey, (PrivateKey)key);
            }
        }
        catch (Exception e) {
            throw new PKIRepositoryException(e);
        }
        return null;
    }
}

