/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.keymg.core.sym.store.KeyStorage;
import org.keymg.core.sym.store.KeyStorageException;
import org.keymg.core.sym.store.SecurityActions;

public class SimpleFileBasedKeyStorage
implements KeyStorage {
    private static Logger log = Logger.getLogger(SimpleFileBasedKeyStorage.class.getName());
    private KeyEntry keys = null;
    private String fileName = "keystore.dat";

    public synchronized boolean store(byte[] symmetricKey, String globalKeyID) throws KeyStorageException {
        this.keys.store(symmetricKey, globalKeyID);
        return true;
    }

    public byte[] retrieve(String globalKeyID) throws KeyStorageException {
        return this.keys.retrieve(globalKeyID);
    }

    public void initialize() throws KeyStorageException {
        URL storedFile;
        File theFile = new File(this.fileName);
        if (!theFile.exists() && (storedFile = SecurityActions.loadResource(this.getClass(), this.fileName)) == null) {
            this.keys = new KeyEntry();
            return;
        }
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            if (theFile != null) {
                fis = new FileInputStream(theFile);
            }
            in = new ObjectInputStream(fis);
            this.keys = (KeyEntry)in.readObject();
            in.close();
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Unable to initialize the key storage", ex);
            throw new KeyStorageException("Unable to initialize the Key Storage");
        }
        catch (ClassNotFoundException ex) {
            log.log(Level.WARNING, "Unable to initialize the key storage", ex);
            throw new KeyStorageException("Unable to initialize the Key Storage");
        }
    }

    public void shutdown() throws KeyStorageException {
        File file = new File(this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new KeyStorageException(e);
            }
        }
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(file);
            out = new ObjectOutputStream(fos);
            out.writeObject(this.keys);
            out.close();
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Unable to shutdown the key storage", ex);
            throw new KeyStorageException();
        }
    }

    private static class KeyEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, byte[]> keyMap = new ConcurrentHashMap<String, byte[]>();

        private KeyEntry() {
        }

        public boolean store(byte[] symmetricKey, String globalKeyID) throws KeyStorageException {
            this.keyMap.put(globalKeyID, symmetricKey);
            return true;
        }

        public byte[] retrieve(String globalKeyID) throws KeyStorageException {
            return this.keyMap.get(globalKeyID);
        }
    }
}

