/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.keymg.core.sym.exceptions.DocumentProcessingException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentUtil {
    public static Document create(String xmlDocument) throws ParserConfigurationException, SAXException, IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException("xmlDocument is null");
        }
        DocumentBuilderFactory factory = DocumentUtil.getFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(xmlDocument)));
    }

    public static String asString(Document doc) throws DocumentProcessingException {
        DOMSource source = new DOMSource(doc);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        try {
            Transformer xformer = DocumentUtil.getTransformer();
            xformer.transform(source, streamResult);
        }
        catch (Exception e) {
            throw new DocumentProcessingException(e);
        }
        return sw.toString();
    }

    public static Document getDocument(InputStream is) throws IOException {
        DocumentBuilderFactory factory = DocumentUtil.getFactory();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public static InputStream getNodeAsStream(Node node) throws IOException {
        return DocumentUtil.getSourceAsStream(new DOMSource(node));
    }

    public static InputStream getSourceAsStream(Source source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, streamResult);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static DocumentBuilderFactory getFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(true);
        return factory;
    }

    private static Transformer getTransformer() throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "no");
        return transformer;
    }
}

