/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.util;

import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.keymg.core.sym.util.SecurityActions;

public class KeyStoreUtil {
    public static KeyStore get(String url, char[] keystorePassword) throws KeyStoreException {
        URL res = SecurityActions.loadResource(KeyStoreUtil.class, "keystore/keymg.keystore");
        KeyStore keystore = KeyStore.getInstance("JCEKS");
        try {
            keystore.load(res.openStream(), keystorePassword);
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
        return keystore;
    }

    public static KeyPair getKeyPair(KeyStore keystore, String alias, char[] password) throws Exception {
        Key key = keystore.getKey(alias, password);
        if (key instanceof PrivateKey) {
            Certificate cert = keystore.getCertificate(alias);
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, (PrivateKey)key);
        }
        return null;
    }
}

