/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.List;
import java.util.StringTokenizer;
import org.keymg.core.sym.config.KeymgConfigurationManager;
import org.keymg.core.sym.generators.SymKeyGenerator;
import org.keymg.core.sym.pki.PKIManager;
import org.keymg.core.sym.policy.SymKeyPolicyStore;
import org.keymg.core.sym.util.DocumentUtil;
import org.keymg.core.sym.util.SymKeyGenUtil;
import org.keymg.sym.model.ekmi.CipherDataType;
import org.keymg.sym.model.ekmi.EncryptionMethodType;
import org.keymg.sym.model.ekmi.GlobalKeyIDType;
import org.keymg.sym.model.ekmi.KeyClassType;
import org.keymg.sym.model.ekmi.KeyClassesType;
import org.keymg.sym.model.ekmi.KeyUsePolicyType;
import org.keymg.sym.model.ekmi.SymkeyRequest;
import org.keymg.sym.model.ekmi.SymkeyResponse;
import org.keymg.sym.model.ekmi.SymkeyType;
import org.keymg.sym.model.ekmi.ValidResponseType;
import org.w3c.dom.Document;

public class SymKeyProcessor {
    protected SymKeyPolicyStore policyStore;
    protected String serverID = null;
    private static int last = 0;

    public static void setLastKeyID(int id) {
        last = id;
    }

    public SymKeyProcessor(SymKeyPolicyStore policyStore) {
        this.policyStore = policyStore;
    }

    public String getServerID() {
        return this.serverID;
    }

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    public Document process(SymkeyRequest symKeyRequest) {
        if (symKeyRequest == null) {
            throw new IllegalArgumentException("symKeyRequest is null");
        }
        List<String> gids = symKeyRequest.getGlobalKeyID();
        SymkeyResponse response = new SymkeyResponse();
        for (String gid : gids) {
            int index = gid.indexOf(45);
            String domainID = gid.substring(0, index);
            KeyClassesType keyClasses = symKeyRequest.getKeyClasses();
            if (keyClasses != null) {
                KeyClassType[] keyClassTypeArr;
                for (KeyClassType keyClassType : keyClassTypeArr = keyClasses.getKeyClassType()) {
                    String keyClass = keyClassType.getValue();
                    KeyUsePolicyType keyUse = this.policyStore.getKeyUsePolicyForKeyClassType(keyClass);
                    if (keyUse != null) continue;
                    keyUse = this.policyStore.getDefaultKeyUsePolicy(domainID);
                }
            }
            ValidResponseType vrt = null;
            vrt = gid.endsWith("0-0") ? this.requestNewKey(gid) : this.requestExistingKey(gid);
            response.add(vrt);
        }
        String responseAsString = response.toString();
        try {
            return DocumentUtil.create(responseAsString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ValidResponseType requestNewKey(String keyID) {
        return this.generate(keyID);
    }

    private ValidResponseType requestExistingKey(String keyID) {
        if (keyID == null) {
            throw new IllegalArgumentException("keyID is null");
        }
        try {
            String tokenPart1;
            int tokens;
            byte[] symmetricKey = KeymgConfigurationManager.getInstance().retrieve(keyID);
            StringTokenizer stringTokenizer = new StringTokenizer(keyID, "-");
            int n = tokens = stringTokenizer != null ? stringTokenizer.countTokens() : 0;
            if (tokens == 0) {
                throw new RuntimeException("Invalid key id" + keyID);
            }
            if (tokens != 3) {
                throw new RuntimeException(keyID + " needs 3 parts");
            }
            String domainID = tokenPart1 = stringTokenizer.nextToken();
            return this.dealWithKey(symmetricKey, domainID, new GlobalKeyIDType(keyID));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ValidResponseType generate(String keyID) {
        String tokenPart1;
        int tokens;
        if (keyID == null) {
            throw new IllegalArgumentException("keyID is null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(keyID, "-");
        int n = tokens = stringTokenizer != null ? stringTokenizer.countTokens() : 0;
        if (tokens == 0) {
            throw new RuntimeException("Invalid key id" + keyID);
        }
        if (tokens != 3) {
            throw new RuntimeException(keyID + " needs 3 parts");
        }
        String domainID = tokenPart1 = stringTokenizer.nextToken();
        if (!tokenPart1.equals(domainID)) {
            throw new IllegalArgumentException("Domain ID of " + tokenPart1 + " does not match with expected " + domainID);
        }
        String tokenPart2 = stringTokenizer.nextToken();
        String tokenPart3 = stringTokenizer.nextToken();
        if (tokenPart2.equals("0") && tokenPart3.equals("0")) {
            SymKeyGenerator symKeyGenerator = new SymKeyGenerator();
            try {
                String keyAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
                byte[] symmetricKey = symKeyGenerator.generate(keyAlgorithm);
                GlobalKeyIDType finalGlobalID = this.getGlobalKey(domainID);
                KeymgConfigurationManager.getInstance().store(symmetricKey, finalGlobalID.getValue());
                return this.dealWithKey(symmetricKey, domainID, finalGlobalID);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public ValidResponseType generate(String keyID, String keyClass) {
        throw new RuntimeException("NYI");
    }

    private ValidResponseType dealWithKey(byte[] symmetricKey, String domainID, GlobalKeyIDType finalGlobalID) throws GeneralSecurityException {
        SymKeyGenerator symKeyGenerator = new SymKeyGenerator();
        PublicKey publicKey = null;
        if (this.policyStore instanceof PKIManager) {
            publicKey = ((PKIManager)((Object)this.policyStore)).getPublicKey(domainID);
        }
        if (publicKey == null) {
            throw new IllegalStateException("no public key found for domain id:" + domainID);
        }
        byte[] encryptedKey = symKeyGenerator.encrypt(symmetricKey, publicKey);
        String base64EncodedKey = SymKeyGenUtil.base64EncodeSymmetricKeyAsString(encryptedKey);
        CipherDataType cipherDataType = new CipherDataType();
        cipherDataType.setCipherValue(base64EncodedKey);
        SymkeyType symKey = new SymkeyType();
        symKey.setEncryptionMethod(EncryptionMethodType.RSA);
        symKey.setCipherData(cipherDataType);
        symKey.setGlobalKeyID(finalGlobalID);
        symKey.setKeyUsePolicy(this.policyStore.getDefaultKeyUsePolicy(domainID));
        return symKey;
    }

    private GlobalKeyIDType getGlobalKey(String domainID) {
        if (this.serverID == null) {
            throw new IllegalStateException("serverID has not been set");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(domainID).append("-").append(this.serverID);
        builder.append("-").append(++last);
        return new GlobalKeyIDType(builder.toString());
    }
}

