/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.config;

import java.io.File;
import java.net.URL;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.keymg.core.sym.config.SecurityActions;
import org.keymg.core.sym.pki.KeyStorePKIManager;
import org.keymg.core.sym.pki.PKIManager;
import org.keymg.core.sym.pki.PKIRepositoryException;
import org.keymg.core.sym.policy.SymKeyPolicyStore;
import org.keymg.core.sym.store.KeyStorage;
import org.keymg.core.sym.store.KeyStorageException;
import org.keymg.sym.model.ekmi.KeyAlgorithmType;
import org.keymg.sym.model.ekmi.KeySizeType;
import org.keymg.sym.model.ekmi.KeyUsePolicyType;
import org.keymg.sym.model.ekmi.StatusType;

public class KeymgConfigurationManager
implements SymKeyPolicyStore,
PKIManager,
KeyStorage {
    private static Logger log = Logger.getLogger(KeymgConfigurationManager.class.getName());
    private String serverID = "1111";
    private String keyAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private int keySize = 256;
    private static PKIManager pkiManager = null;
    private static SymKeyPolicyStore policyStore = null;
    private static KeyStorage keyStorage = null;
    private static KeymgConfigurationManager instance = new KeymgConfigurationManager();

    private KeymgConfigurationManager() {
    }

    public static KeymgConfigurationManager getInstance() {
        return instance;
    }

    public static void setPKIManager(PKIManager pki) {
        pkiManager = pki;
    }

    public static void setUp() {
        if (keyStorage == null) {
            log.log(Level.WARNING, "setUp called without a key storage");
            return;
        }
        try {
            keyStorage.initialize();
        }
        catch (KeyStorageException e) {
            log.log(Level.WARNING, "Cannot initialize key storage:", e);
        }
    }

    public static void destroy() {
        try {
            keyStorage.shutdown();
        }
        catch (KeyStorageException e) {
            log.log(Level.WARNING, "Cannot shutdown key storage:", e);
        }
    }

    public static void setPolicyStore(SymKeyPolicyStore policyStore) {
        KeymgConfigurationManager.policyStore = policyStore;
    }

    public static void setKeyStorage(KeyStorage keyStorage) {
        KeymgConfigurationManager.keyStorage = keyStorage;
    }

    public String getServerID() {
        return this.serverID;
    }

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public KeyUsePolicyType getKeyUsePolicyType() {
        KeyUsePolicyType keyUsePolicy = new KeyUsePolicyType();
        keyUsePolicy.setKeyAlgorithm(KeyAlgorithmType.reverse(this.keyAlgorithm));
        keyUsePolicy.setKeySize(new KeySizeType(this.keySize));
        keyUsePolicy.setStatus(StatusType.ACTIVE);
        return keyUsePolicy;
    }

    public PublicKey getPublicKeyForDomain(String domainID) throws PKIRepositoryException {
        this.ensureKeyStore();
        return pkiManager.getPublicKey(domainID);
    }

    public KeyUsePolicyType getKeyUsePolicy(String keyUsePolicyID) {
        if (policyStore == null) {
            throw new RuntimeException("Policy Store not set");
        }
        return policyStore.getKeyUsePolicy(keyUsePolicyID);
    }

    public KeyUsePolicyType getDefaultKeyUsePolicy(String domainID) {
        if (policyStore == null) {
            throw new RuntimeException("Policy Store not set");
        }
        return policyStore.getDefaultKeyUsePolicy(domainID);
    }

    public KeyUsePolicyType getKeyUsePolicyForKeyClassType(String keyClassType) {
        if (policyStore == null) {
            throw new RuntimeException("Policy Store not set");
        }
        return policyStore.getKeyUsePolicyForKeyClassType(keyClassType);
    }

    public KeyPair getKeyPair(String domainID) throws PKIRepositoryException {
        this.ensureKeyStore();
        return pkiManager.getKeyPair(domainID);
    }

    public PublicKey getPublicKey(String domainID) throws PKIRepositoryException {
        this.ensureKeyStore();
        return pkiManager.getPublicKey(domainID);
    }

    public void register(String domainID, Certificate cert) throws PKIRepositoryException {
        this.ensureKeyStore();
        pkiManager.register(domainID, cert);
    }

    public void initialize() throws KeyStorageException {
        if (keyStorage == null) {
            throw new KeyStorageException("Key Storage has not been set");
        }
        keyStorage.initialize();
    }

    public boolean store(byte[] symmetricKey, String globalKeyID) throws KeyStorageException {
        if (keyStorage == null) {
            throw new KeyStorageException("Key Storage has not been set");
        }
        return keyStorage.store(symmetricKey, globalKeyID);
    }

    public byte[] retrieve(String globalKeyID) throws KeyStorageException {
        if (keyStorage == null) {
            throw new KeyStorageException("Key Storage has not been set");
        }
        return keyStorage.retrieve(globalKeyID);
    }

    public void shutdown() throws KeyStorageException {
        if (keyStorage == null) {
            throw new KeyStorageException("Key Storage has not been set");
        }
        keyStorage.shutdown();
    }

    private void ensureKeyStore() throws PKIRepositoryException {
        if (pkiManager == null) {
            URL keyStoreURL = SecurityActions.loadResource(this.getClass(), "keystore/keymg.keystore");
            if (keyStoreURL == null) {
                throw new PKIRepositoryException("keyStoreURL is null");
            }
            pkiManager = new KeyStorePKIManager(new File(keyStoreURL.getPath()), "keymg$".toCharArray());
        }
    }
}

