/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.io.StringReader;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keymg.core.sym.parse.XMLParser;
import org.keymg.sym.model.ekmi.KeyCachePolicyRequestType;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class KeyCachePolicyRequestParser
implements XMLParser {
    private static Logger log = Logger.getLogger(KeyCachePolicyRequestParser.class.getCanonicalName());

    public boolean acceptsQName(QName qname) {
        return false;
    }

    public QName[] getQNames() {
        return null;
    }

    public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        KeyCachePolicyRequestType keyCachePolicyReq = (KeyCachePolicyRequestType)populateObject;
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if (localPart.equals("Signature")) {
                            Element elem = this.getSignatureElement(xmlEventReader, ev.asStartElement());
                            keyCachePolicyReq.setSignature(elem);
                            break;
                        }
                        throw new RuntimeException("Unknown element:" + localPart);
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("KeyCachePolicyRequest")) break;
                        return;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
    }

    protected Element getSignatureElement(XMLEventReader xmlEventReader, StartElement sigElement) {
        try {
            StringBuilder builder = new StringBuilder();
            QName sigName = sigElement.getName();
            String prefix = sigName.getPrefix();
            builder.append("<").append(prefix).append(":").append(sigName.getLocalPart());
            builder.append(" xmlns:").append(prefix).append("=\"http://www.w3.org/2000/09/xmldsig#\"").append(">");
            while (xmlEventReader.hasNext()) {
                QName name;
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (xmlEvent instanceof EndElement) {
                    EndElement end = (EndElement)xmlEvent;
                    name = end.getName();
                    builder.append("</").append(name.getPrefix()).append(":").append(name.getLocalPart()).append(">");
                    String localPart = name.getLocalPart();
                    if (!"Signature".equals(localPart)) continue;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    DocumentBuilder docBuilder = factory.newDocumentBuilder();
                    String str = builder.toString().trim();
                    InputSource source = new InputSource(new StringReader(str));
                    return docBuilder.parse(source).getDocumentElement();
                }
                if (xmlEvent instanceof StartElement) {
                    StartElement start = (StartElement)xmlEvent;
                    name = start.getName();
                    builder.append("<").append(name.getPrefix()).append(":").append(name.getLocalPart());
                    Iterator<Attribute> iter = start.getAttributes();
                    while (iter != null && iter.hasNext()) {
                        Attribute attr = iter.next();
                        builder.append(" ");
                        builder.append(attr.toString());
                    }
                    builder.append(">");
                    continue;
                }
                builder.append(xmlEvent.toString().trim());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

