/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keymg.core.sym.SymKeyConstants;
import org.keymg.core.sym.parse.PermissionsParser;
import org.keymg.core.sym.parse.XMLParser;
import org.keymg.sym.model.ekmi.KeyAlgorithmType;
import org.keymg.sym.model.ekmi.KeyClassType;
import org.keymg.sym.model.ekmi.KeySizeType;
import org.keymg.sym.model.ekmi.KeyUsePolicyType;
import org.keymg.sym.model.ekmi.StatusType;
import org.keymg.sym.model.ekmi.SymkeyType;
import org.keymg.sym.model.ekmi.TwoPartIDType;

public class KeyUsePolicyParser
implements XMLParser {
    private static Logger log = Logger.getLogger(KeyUsePolicyParser.class.getCanonicalName());
    private final QName qname = SymKeyConstants.QNameConstants.KEYUSEPOLICY_QNAME.get();

    public boolean acceptsQName(QName qname) {
        String localPart = qname.getLocalPart();
        String ns = qname.getNamespaceURI();
        return qname.getLocalPart().equals(localPart) && qname.getNamespaceURI().equals(ns);
    }

    public QName[] getQNames() {
        return new QName[]{this.qname};
    }

    public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        SymkeyType symKey = (SymkeyType)populateObject;
        KeyUsePolicyType keyUsePolicyType = new KeyUsePolicyType();
        symKey.setKeyUsePolicy(keyUsePolicyType);
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if ("KeyUsePolicyID".equals(localPart)) {
                            String keyPolicyID = xmlEventReader.getElementText();
                            TwoPartIDType twoPartIdType = new TwoPartIDType(keyPolicyID);
                            keyUsePolicyType.setKeyUsePolicyID(twoPartIdType);
                            break;
                        }
                        if ("PolicyName".equals(localPart)) {
                            String policyName = xmlEventReader.getElementText();
                            keyUsePolicyType.setPolicyName(policyName);
                            break;
                        }
                        if ("KeyClass".equals(localPart)) {
                            String keyClass = xmlEventReader.getElementText();
                            keyUsePolicyType.setKeyClass(new KeyClassType(keyClass));
                            break;
                        }
                        if ("KeyAlgorithm".equals(localPart)) {
                            String keyAlgorithm = xmlEventReader.getElementText();
                            keyUsePolicyType.setKeyAlgorithm(KeyAlgorithmType.reverse(keyAlgorithm));
                            break;
                        }
                        if ("KeySize".equals(localPart)) {
                            String keySize = xmlEventReader.getElementText();
                            keyUsePolicyType.setKeySize(new KeySizeType(Integer.parseInt(keySize)));
                            break;
                        }
                        if ("Permissions".equals(localPart)) {
                            PermissionsParser permissionsParser = new PermissionsParser();
                            permissionsParser.handle(xmlEventReader, xmlEvent, keyUsePolicyType);
                            break;
                        }
                        if (!"Status".equals(localPart)) break;
                        String status = xmlEventReader.getElementText();
                        keyUsePolicyType.setStatus(StatusType.fromValue(status));
                        break;
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("KeyUsePolicy")) break;
                        return;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
    }
}

