/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.parse;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keymg.core.sym.SymKeyConstants;
import org.keymg.core.sym.parse.KeyUsePolicyParser;
import org.keymg.core.sym.parse.XMLParser;
import org.keymg.sym.model.ekmi.CipherDataType;
import org.keymg.sym.model.ekmi.EncryptionMethodType;
import org.keymg.sym.model.ekmi.GlobalKeyIDType;
import org.keymg.sym.model.ekmi.SymkeyErrorType;
import org.keymg.sym.model.ekmi.SymkeyRequestIDType;
import org.keymg.sym.model.ekmi.SymkeyResponse;
import org.keymg.sym.model.ekmi.SymkeyType;
import org.keymg.sym.model.ekmi.SymkeyWorkInProgressType;

public class SymkeyParser
implements XMLParser {
    private static Logger log = Logger.getLogger(SymkeyParser.class.getCanonicalName());
    private final QName qname = SymKeyConstants.QNameConstants.SYMKEY_QNAME.get();

    public boolean acceptsQName(QName qname) {
        String localPart = qname.getLocalPart();
        String ns = qname.getNamespaceURI();
        return qname.getLocalPart().equals(localPart) && qname.getNamespaceURI().equals(ns);
    }

    public QName[] getQNames() {
        return new QName[]{this.qname};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        SymkeyResponse response = (SymkeyResponse)populateObject;
        if (xmlEvent instanceof StartElement) {
            StartElement startEl = (StartElement)xmlEvent;
            String local = startEl.getName().getLocalPart();
            if ("SymkeyError".equals(local)) {
                SymkeyErrorType symErr = this.handleError(xmlEventReader, xmlEvent, populateObject);
                response.add(symErr);
                return;
            }
            if ("SymkeyWorkInProgress".equals(local)) {
                SymkeyWorkInProgressType symWIP = this.handleWorkInProgress(xmlEventReader, xmlEvent, populateObject);
                response.add(symWIP);
                return;
            }
        }
        SymkeyType symKey = new SymkeyType();
        response.add(symKey);
        try {
            block7: while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if ("SymkeyRequestID".equals(localPart)) {
                            String requestID = xmlEventReader.getElementText().trim();
                            symKey.setSymkeyRequestID(new SymkeyRequestIDType(requestID));
                            break;
                        }
                        if ("GlobalKeyID".equals(localPart)) {
                            String globalKeyId = xmlEventReader.getElementText().trim();
                            symKey.setGlobalKeyID(new GlobalKeyIDType(globalKeyId));
                            break;
                        }
                        if ("EncryptionMethod".equals(localPart)) {
                            Iterator<Attribute> attributes = nextStartElement.getAttributes();
                            while (attributes.hasNext()) {
                                Attribute attribute = attributes.next();
                                if (!attribute.getName().getLocalPart().equals("Algorithm")) continue;
                                String encUri = attribute.getValue();
                                symKey.setEncryptionMethod(EncryptionMethodType.reverse(encUri));
                            }
                            continue block7;
                        }
                        if ("KeyUsePolicy".equals(localPart)) {
                            KeyUsePolicyParser keyUsePolicyParser = new KeyUsePolicyParser();
                            keyUsePolicyParser.handle(xmlEventReader, xmlEvent, symKey);
                            break;
                        }
                        if (!"CipherData".equals(localPart)) break;
                        CipherDataType cipherData = new CipherDataType();
                        while (!((xmlEvent = xmlEventReader.nextEvent()) instanceof StartElement)) {
                        }
                        cipherData.setCipherValue(xmlEventReader.getElementText());
                        symKey.setCipherData(cipherData);
                        break;
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("Symkey")) break;
                        return;
                    }
                    case 8: {
                        return;
                    }
                }
            }
            return;
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
    }

    private SymkeyErrorType handleError(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        SymkeyErrorType symError = new SymkeyErrorType();
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if ("SymkeyRequestID".equals(localPart)) {
                            String requestID = xmlEventReader.getElementText().trim();
                            symError.setSymkeyRequestID(requestID);
                            break;
                        }
                        if ("RequestedGlobalKeyID".equals(localPart)) {
                            String globalKeyId = xmlEventReader.getElementText().trim();
                            symError.setRequestedGlobalKeyID(globalKeyId);
                            break;
                        }
                        if ("RequestedKeyClass".equals(localPart)) {
                            String globalKeyClass = xmlEventReader.getElementText().trim();
                            symError.setRequestedKeyClass(globalKeyClass);
                            break;
                        }
                        if ("ErrorCode".equals(localPart)) {
                            String errorCode = xmlEventReader.getElementText().trim();
                            symError.setErrorCode(errorCode);
                            break;
                        }
                        if ("ErrorMessage".equals(localPart)) {
                            String errorMsg = xmlEventReader.getElementText().trim();
                            symError.setErrorMessage(errorMsg);
                            break;
                        }
                        throw new RuntimeException("Unknown Element:" + localPart);
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("Symkey")) break;
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
        return symError;
    }

    private SymkeyWorkInProgressType handleWorkInProgress(XMLEventReader xmlEventReader, XMLEvent xmlEvent, Object populateObject) throws XMLStreamException {
        SymkeyWorkInProgressType symWIP = new SymkeyWorkInProgressType();
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent ev = xmlEventReader.nextEvent();
                switch (ev.getEventType()) {
                    case 1: {
                        StartElement nextStartElement = (StartElement)ev;
                        QName elementName = nextStartElement.getName();
                        String localPart = elementName.getLocalPart();
                        if ("SymkeyRequestID".equals(localPart)) {
                            String requestID = xmlEventReader.getElementText().trim();
                            symWIP.setSymkeyRequestID(requestID);
                            break;
                        }
                        if ("RequestedGlobalKeyID".equals(localPart)) {
                            String globalKeyId = xmlEventReader.getElementText().trim();
                            symWIP.setRequestedGlobalKeyID(globalKeyId);
                            break;
                        }
                        if ("RequestedKeyClass".equals(localPart)) {
                            String reqKeyClass = xmlEventReader.getElementText().trim();
                            symWIP.setRequestedKeyClass(reqKeyClass);
                            break;
                        }
                        if ("RequestCheckInterval".equals(localPart)) {
                            String reqCheckInInt = xmlEventReader.getElementText().trim();
                            symWIP.setRequestCheckInterval(Integer.valueOf(reqCheckInInt));
                            break;
                        }
                        throw new RuntimeException("Unknown Element:" + localPart);
                    }
                    case 2: {
                        EndElement endElement = (EndElement)ev;
                        String localPart = endElement.getName().getLocalPart();
                        if (!localPart.equals("Symkey")) break;
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Unable to parse:", e);
        }
        return symWIP;
    }
}

