/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.core.sym.writers;

import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.keymg.sym.model.ekmi.ApplicationsType;
import org.keymg.sym.model.ekmi.CipherDataType;
import org.keymg.sym.model.ekmi.KeyClassType;
import org.keymg.sym.model.ekmi.KeyClassesType;
import org.keymg.sym.model.ekmi.KeyUsePolicyType;
import org.keymg.sym.model.ekmi.LevelClassificationType;
import org.keymg.sym.model.ekmi.PermissionsType;
import org.keymg.sym.model.ekmi.PermittedApplicationsType;
import org.keymg.sym.model.ekmi.PermittedDatesType;
import org.keymg.sym.model.ekmi.PermittedDayType;
import org.keymg.sym.model.ekmi.PermittedDaysType;
import org.keymg.sym.model.ekmi.PermittedDurationType;
import org.keymg.sym.model.ekmi.PermittedLevelsType;
import org.keymg.sym.model.ekmi.PermittedLocationsType;
import org.keymg.sym.model.ekmi.PermittedNumberOfTransactionsType;
import org.keymg.sym.model.ekmi.PermittedTimesType;
import org.keymg.sym.model.ekmi.PermittedUsesType;
import org.keymg.sym.model.ekmi.SymkeyRequest;
import org.keymg.sym.model.ekmi.SymkeyResponse;
import org.keymg.sym.model.ekmi.SymkeyType;
import org.keymg.sym.model.ekmi.ValidResponseType;

public class SymkeyWriter {
    XMLStreamWriter writer = null;

    public SymkeyWriter(OutputStream outStream) throws XMLStreamException {
        this.writer = this.getXMLStreamWriter(outStream);
    }

    public void write(SymkeyRequest request) throws XMLStreamException {
        this.writer.writeStartElement("ekmi", "SymkeyRequest", "http://docs.oasis-open.org/ekmi/2008/01");
        this.writer.writeNamespace("ekmi", "http://docs.oasis-open.org/ekmi/2008/01");
        List<String> globalKeyIDs = request.getGlobalKeyID();
        for (String globalKeyID : globalKeyIDs) {
            this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "GlobalKeyID");
            this.writer.writeCharacters(globalKeyID);
            this.writer.writeEndElement();
        }
        KeyClassesType keyClassesType = request.getKeyClasses();
        if (keyClassesType != null) {
            this.write(keyClassesType);
        }
        this.writer.writeEndElement();
        this.writer.flush();
    }

    public void write(SymkeyResponse response) throws XMLStreamException {
        this.writer.writeStartElement("ekmi", "SymkeyResponse", "http://docs.oasis-open.org/ekmi/2008/01");
        this.writer.writeNamespace("ekmi", "http://docs.oasis-open.org/ekmi/2008/01");
        this.writer.writeNamespace("xenc", "http://www.w3.org/2001/04/xmlenc#");
        this.writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        List<ValidResponseType> responseTypes = response.getResponse();
        for (ValidResponseType responseType : responseTypes) {
            this.write(responseType);
        }
        this.writer.writeEndElement();
        this.writer.flush();
    }

    public void write(ValidResponseType valid) throws XMLStreamException {
        if (valid instanceof SymkeyType) {
            this.write((SymkeyType)valid);
            return;
        }
        throw new RuntimeException("Should not have reached here:" + valid.toString());
    }

    public void write(SymkeyType symKey) throws XMLStreamException {
        this.writer.writeStartElement("ekmi", "Symkey", "http://docs.oasis-open.org/ekmi/2008/01");
        this.writer.writeStartElement("ekmi", "SymkeyRequestID", "http://docs.oasis-open.org/ekmi/2008/01");
        this.writer.writeCharacters(symKey.getSymkeyRequestID().getValue());
        this.writer.writeEndElement();
        this.writer.writeStartElement("ekmi", "GlobalKeyID", "http://docs.oasis-open.org/ekmi/2008/01");
        this.writer.writeCharacters(symKey.getGlobalKeyID().getValue());
        this.writer.writeEndElement();
        KeyUsePolicyType keyUsePolicy = symKey.getKeyUsePolicy();
        if (keyUsePolicy != null) {
            this.write(keyUsePolicy);
        }
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "EncryptionMethod");
        this.writer.writeCharacters(symKey.getEncryptionMethod().get());
        this.writer.writeEndElement();
        CipherDataType cipherData = symKey.getCipherData();
        this.write(cipherData);
        this.writer.writeEndElement();
        this.writer.flush();
    }

    public void write(KeyClassesType keyClassesType) throws XMLStreamException {
        KeyClassType[] keyClassTypeArr;
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "KeyClasses");
        for (KeyClassType keyClassType : keyClassTypeArr = keyClassesType.getKeyClassType()) {
            this.write(keyClassType);
        }
        this.writer.writeEndElement();
        this.writer.flush();
    }

    public void write(KeyClassType keyClassType) throws XMLStreamException {
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "KeyClass");
        this.writer.writeCharacters(keyClassType.getValue());
        this.writer.writeEndElement();
    }

    public void write(KeyUsePolicyType keyUsePolicy) throws XMLStreamException {
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "KeyUsePolicy");
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "KeyUsePolicyID");
        this.writer.writeCharacters(keyUsePolicy.getKeyUsePolicyID().getValue());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "PolicyName");
        this.writer.writeCharacters(keyUsePolicy.getPolicyName());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "KeyClass");
        this.writer.writeCharacters(keyUsePolicy.getKeyClass().getValue());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "KeyAlgorithm");
        this.writer.writeCharacters(keyUsePolicy.getKeyAlgorithm().get());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "KeySize");
        this.writer.writeCharacters(keyUsePolicy.getKeySize().getValue() + "");
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "Status");
        this.writer.writeCharacters(keyUsePolicy.getStatus().value());
        this.writer.writeEndElement();
        PermissionsType permissions = keyUsePolicy.getPermissions();
        if (permissions != null) {
            this.write(permissions);
        }
        this.writer.writeEndElement();
    }

    public void write(PermissionsType permissions) throws XMLStreamException {
        PermittedUsesType permittedUses;
        PermittedTimesType permittedTimes;
        PermittedNumberOfTransactionsType permittedNumTxs;
        PermittedLocationsType permittedLocations;
        PermittedLevelsType permittedLevels;
        PermittedDurationType permittedDurations;
        PermittedDaysType permittedDays;
        PermittedDatesType permittedDates;
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "Permissions");
        PermittedApplicationsType permittedApplications = permissions.getPermittedApplications();
        if (permittedApplications != null) {
            this.write(permittedApplications);
        }
        if ((permittedDates = permissions.getPermittedDates()) != null) {
            this.write(permittedDates);
        }
        if ((permittedDays = permissions.getPermittedDays()) != null) {
            this.write(permittedDays);
        }
        if ((permittedDurations = permissions.getPermittedDuration()) != null) {
            this.write(permittedDurations);
        }
        if ((permittedLevels = permissions.getPermittedLevels()) != null) {
            this.write(permittedLevels);
        }
        if ((permittedLocations = permissions.getPermittedLocations()) != null) {
            this.write(permittedLocations);
        }
        if ((permittedNumTxs = permissions.getPermittedNumberOfTransactions()) != null) {
            this.write(permittedNumTxs);
        }
        if ((permittedTimes = permissions.getPermittedTimes()) != null) {
            this.write(permittedTimes);
        }
        if ((permittedUses = permissions.getPermittedUses()) != null) {
            this.write(permittedUses);
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedApplicationsType permittedApplications) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedApplications");
        List<ApplicationsType> permittedAppList = permittedApplications.getPermittedApplication();
        if (permittedAppList.size() > 0) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        for (ApplicationsType app : permittedAppList) {
            this.write(app);
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedDatesType permittedDates) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedDates");
        List<PermittedDatesType.PermittedDate> permittedDatesList = permittedDates.getPermittedDate();
        if (permittedDatesList.size() > 0) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        for (PermittedDatesType.PermittedDate app : permittedDatesList) {
            this.write(app);
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedDaysType permittedDays) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedDays");
        List<PermittedDayType> permittedDaysList = permittedDays.getPermittedDay();
        if (permittedDaysList.size() > 0) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        for (PermittedDayType app : permittedDaysList) {
            this.write(app);
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedDurationType permittedDuration) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedDuration");
        BigInteger duration = permittedDuration.getValue();
        if (duration != null) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        if (duration != null) {
            this.writer.writeCharacters(duration.toString());
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedLevelsType permittedLevels) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedLevels");
        List<LevelClassificationType> permittedLevelsList = permittedLevels.getPermittedLevel();
        if (permittedLevelsList.size() > 0) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        for (LevelClassificationType app : permittedLevelsList) {
            this.write(app);
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedLocationsType permittedLocations) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedLocations");
        List<PermittedLocationsType.PermittedLocation> permittedLocationsList = permittedLocations.getPermittedLocation();
        if (permittedLocationsList.size() > 0) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        for (PermittedLocationsType.PermittedLocation app : permittedLocationsList) {
            this.write(app);
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedNumberOfTransactionsType permittedApplications) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedNumberOfTransactions");
        BigInteger tx = permittedApplications.getValue();
        if (tx != null) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
            this.writer.writeCharacters(tx.toString());
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedTimesType permittedApplications) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedTimes");
        List<PermittedTimesType.PermittedTime> permittedAppList = permittedApplications.getPermittedTime();
        if (permittedAppList.size() > 0) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        for (PermittedTimesType.PermittedTime app : permittedAppList) {
            this.write(app);
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedUsesType permittedUses) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedUses");
        List<Serializable> permittedAppList = permittedUses.getContent();
        if (permittedAppList.size() > 0) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        for (Serializable app : permittedAppList) {
            this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedUse");
            this.writer.writeCharacters(app.toString());
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedDayType permittedDay) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedDate");
        this.writer.writeCharacters(permittedDay.value());
        this.writer.writeEndElement();
    }

    public void write(LevelClassificationType permittedLevel) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedLevel");
        this.writer.writeCharacters(permittedLevel.get());
        this.writer.writeEndElement();
    }

    public void write(ApplicationsType permittedApplication) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedApplication");
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "ApplicationID");
        this.writer.writeCharacters(permittedApplication.getApplicationID());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "ApplicationName");
        this.writer.writeCharacters(permittedApplication.getApplicationName());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "ApplicationVersion");
        this.writer.writeCharacters(permittedApplication.getVersion());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "ApplicationDigestAlgorithm");
        this.writer.writeCharacters(permittedApplication.getDigestAlgorithm());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "ApplicationDigestValue");
        this.writer.writeCharacters(new String(permittedApplication.getDigestValue()));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    public void write(PermittedLocationsType.PermittedLocation permittedLocation) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedLocation");
        String locationName = permittedLocation.getLocationName();
        if (locationName != null) {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "false");
            this.writer.writeStartElement("http://docs.oasis-open.org/ekmi/2008/01", "LocationName");
            this.writer.writeCharacters(locationName);
            this.writer.writeEndElement();
        } else {
            this.writer.writeAttribute("ekmi", "http://docs.oasis-open.org/ekmi/2008/01", "any", "true");
        }
        this.writer.writeEndElement();
    }

    public void write(PermittedDatesType.PermittedDate permittedDate) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedDate");
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "StartDate");
        this.writer.writeCharacters(permittedDate.getStartDate().toString());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "EndDate");
        this.writer.writeCharacters(permittedDate.getEndDate().toString());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    public void write(PermittedTimesType.PermittedTime permittedTime) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "PermittedTime");
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "StartTime");
        this.writer.writeCharacters(permittedTime.getStartTime().toString());
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "EndTime");
        this.writer.writeCharacters(permittedTime.getEndTime().toString());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    public void write(CipherDataType cipherData) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "CipherData");
        this.writer.writeStartElement("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        this.writer.writeCharacters(cipherData.getCipherValue());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private XMLStreamWriter getXMLStreamWriter(OutputStream outStream) throws XMLStreamException {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        return xmlOutputFactory.createXMLStreamWriter(outStream, "UTF-8");
    }
}

