/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.sym.model.ekmi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum KeyAlgorithmType {
    TRIPLE_DES("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"),
    AES_128_CBS("http://www.w3.org/2001/04/xmlenc#aes128-cbc"),
    AES_192_CBS("http://www.w3.org/2001/04/xmlenc#aes192-cbc"),
    AES_256_CBS("http://www.w3.org/2001/04/xmlenc#aes256-cbc");

    private String uri;

    private KeyAlgorithmType(String uri) {
        this.uri = uri;
    }

    public String get() {
        return this.uri;
    }

    public static KeyAlgorithmType reverse(String uri) {
        if ((uri = uri.trim()).equals(KeyAlgorithmType.TRIPLE_DES.uri)) {
            return TRIPLE_DES;
        }
        if (uri.equals(KeyAlgorithmType.AES_128_CBS.uri)) {
            return AES_128_CBS;
        }
        if (uri.equals(KeyAlgorithmType.AES_192_CBS.uri)) {
            return AES_192_CBS;
        }
        if (uri.equals(KeyAlgorithmType.AES_256_CBS.uri)) {
            return AES_256_CBS;
        }
        throw new RuntimeException("Unknown uri:" + uri);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<ekmi:KeyAlgorithm>");
        builder.append(this.uri);
        builder.append("</ekmi:KeyAlgorithm>");
        return builder.toString();
    }
}

