/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.sym.model.ekmi;

import java.util.regex.Pattern;
import org.keymg.sym.exceptions.StringFormatException;

public class ThreePartIDType {
    private String value;

    public ThreePartIDType() {
    }

    public ThreePartIDType(String value) {
        this.validate(value);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.validate(value);
        this.value = value;
    }

    protected void validate(String val) {
        if (val == null) {
            throw new IllegalArgumentException(" val is null");
        }
        int length = (val = val.trim()).length();
        if (length < 5) {
            throw new StringFormatException("Need at least 5 characters:" + length);
        }
        if (length > 62) {
            throw new StringFormatException("At most 62 character allowed:" + length);
        }
        if (!Pattern.matches("[1-9][0-9]{0,19}-[1-9][0-9]{0,19}-[1-9][0-9]{0,19}", val)) {
            throw new StringFormatException("pattern does not match [1-9][0-9]{0,19}-[1-9][0-9]{0,19}-[1-9][0-9]{0,19}:" + val);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreePartIDType other = (ThreePartIDType)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

