/*
 * Decompiled with CFR 0.152.
 */
package org.keymg.web.servlets;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import org.keymg.core.sym.SymKeyProcessor;
import org.keymg.core.sym.config.KeymgConfigurationManager;
import org.keymg.core.sym.parse.Parser;
import org.keymg.core.sym.pki.PKIManager;
import org.keymg.core.sym.policy.InmemorySymKeyPolicyStore;
import org.keymg.core.sym.policy.SymKeyPolicyStore;
import org.keymg.core.sym.store.KeyStorage;
import org.keymg.core.sym.store.SimpleFileBasedKeyStorage;
import org.keymg.core.sym.util.DocumentUtil;
import org.keymg.sym.model.ekmi.SymkeyRequest;
import org.keymg.web.servlets.SecurityActions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KeymgServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected ServletConfig config = null;
    protected SymKeyProcessor processor;
    protected String policyStoreName = InmemorySymKeyPolicyStore.class.getName();
    protected String serverID = "1";

    public void init(ServletConfig config) throws ServletException {
        Class<?> policyStoreClass;
        super.init(config);
        this.config = config;
        String psn = config.getInitParameter("policyStoreName");
        if (psn != null && !psn.isEmpty()) {
            this.policyStoreName = psn;
        }
        if ((policyStoreClass = SecurityActions.load(((Object)((Object)this)).getClass(), this.policyStoreName)) == null) {
            throw new ServletException("Unable to load the policy Store");
        }
        KeymgConfigurationManager configManager = KeymgConfigurationManager.getInstance();
        SymKeyPolicyStore policyStore = null;
        try {
            policyStore = (SymKeyPolicyStore)policyStoreClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        KeymgConfigurationManager.setPolicyStore((SymKeyPolicyStore)policyStore);
        String serverIDStr = config.getInitParameter("serverID");
        if (serverIDStr != null && !serverIDStr.isEmpty()) {
            this.serverID = serverIDStr;
        }
        SimpleFileBasedKeyStorage keyStorage = new SimpleFileBasedKeyStorage();
        String keyStorageStr = config.getInitParameter("keyStorage");
        if (keyStorageStr != null && !keyStorageStr.isEmpty()) {
            try {
                keyStorage = (KeyStorage)SecurityActions.load(((Object)((Object)this)).getClass(), keyStorageStr).newInstance();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        try {
            KeymgConfigurationManager.setKeyStorage((KeyStorage)keyStorage);
            keyStorage.initialize();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        PKIManager pkiManager = null;
        String pkiManagerStr = config.getInitParameter("pkiManager");
        if (pkiManagerStr != null && !pkiManagerStr.isEmpty()) {
            try {
                pkiManager = (PKIManager)SecurityActions.load(((Object)((Object)this)).getClass(), pkiManagerStr).newInstance();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        try {
            if (pkiManager != null) {
                KeymgConfigurationManager.setPKIManager(pkiManager);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        this.processor = new SymKeyProcessor((SymKeyPolicyStore)configManager);
        this.processor.setServerID(this.serverID);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletInputStream inputStream = req.getInputStream();
        Document doc = DocumentUtil.getDocument((InputStream)inputStream);
        doc = this.decrypt(doc);
        Parser parser = new Parser();
        try {
            parser.parse(DocumentUtil.getNodeAsStream((Node)doc));
        }
        catch (XMLStreamException e) {
            this.log("Exception handling request:", e);
            throw new ServletException();
        }
        Object parsedObject = parser.getParsedObject();
        if (parsedObject instanceof SymkeyRequest) {
            SymkeyRequest symKeyRequest = (SymkeyRequest)parsedObject;
            doc = this.processor.process(symKeyRequest);
        }
        doc = this.encrypt(doc);
        resp.setContentType("text/xml;charset=utf-8");
        ServletOutputStream os = resp.getOutputStream();
        InputStream docStream = DocumentUtil.getNodeAsStream((Node)doc);
        int ch = 0;
        while ((ch = docStream.read()) != -1) {
            os.write(ch);
        }
    }

    public void destroy() {
        KeymgConfigurationManager.destroy();
        super.destroy();
    }

    protected Document decrypt(Document doc) {
        return doc;
    }

    protected Document encrypt(Document doc) {
        return doc;
    }
}

