/*
 * Decompiled with CFR 0.152.
 */
package org.kgusarov.integration.spring.netty;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.kgusarov.integration.spring.netty.ChannelOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpServer.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Map<String, Supplier<ChannelHandler>> handlers = Maps.newLinkedHashMap();
    private final List<Supplier<ChannelFutureListener>> closeFutureListeners = Lists.newArrayList();
    private final List<Supplier<ChannelHandler>> channelActiveHandlers = Lists.newArrayList();
    private final String name;
    private int bossThreads = Runtime.getRuntime().availableProcessors();
    private int workerThreads = Runtime.getRuntime().availableProcessors();
    private String host;
    private int port;
    private ChannelOptions options = new ChannelOptions();
    private ChannelOptions childOptions = new ChannelOptions();
    private EventLoopGroup bossThreadGroup;
    private EventLoopGroup workerThreadGroup;
    private int boundToPort = -1;

    public TcpServer(String name) {
        this.name = name;
    }

    public int getBoundToPort() {
        return this.boundToPort;
    }

    public void setBossThreads(int bossThreads) {
        this.checkState().bossThreads = bossThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        this.checkState().workerThreads = workerThreads;
    }

    public void setHost(String host) {
        this.checkState().host = host;
    }

    public void setPort(int port) {
        this.checkState().port = port;
    }

    public void setOptions(ChannelOptions options) {
        this.checkState().options = options;
    }

    public void setChildOptions(ChannelOptions childOptions) {
        this.checkState().childOptions = childOptions;
    }

    void stop() {
        LOGGER.info("Stopping Netty `{}`", (Object)this.name);
        this.workerThreadGroup.shutdownGracefully();
        this.bossThreadGroup.shutdownGracefully();
        this.workerThreadGroup.terminationFuture().syncUninterruptibly();
        this.bossThreadGroup.terminationFuture().syncUninterruptibly();
    }

    public void onDisconnect(Supplier<ChannelFutureListener> listener) {
        this.checkState().closeFutureListeners.add(listener);
    }

    public void onConnect(Supplier<ChannelHandler> handler) {
        this.checkState().channelActiveHandlers.add(handler);
    }

    public void addHandler(String name, Supplier<ChannelHandler> channelHandler) {
        this.checkState().handlers.put(name, channelHandler);
    }

    ListenableFuture<Void> start() {
        if (!this.channelActiveHandlers.isEmpty()) {
            int i = 1;
            for (Supplier<ChannelHandler> channelActiveHandler : this.channelActiveHandlers) {
                this.addHandler("channelActive" + i++, channelActiveHandler);
            }
        }
        LOGGER.info("Starting Netty server `{}` with {} boss threads and {} worker threads", new Object[]{this.name, this.bossThreads, this.workerThreads});
        SettableFuture result = SettableFuture.create();
        ServerBootstrap serverBootstrap = this.checkState().createServerBootstrap();
        Channel ch = serverBootstrap.bind(this.host, this.port).syncUninterruptibly().channel();
        new Thread(() -> {
            InetSocketAddress boundTo = (InetSocketAddress)ch.localAddress();
            String hostName = boundTo.getAddress().getHostName();
            this.boundToPort = boundTo.getPort();
            LOGGER.info("Started Netty server `{}` @{}:{}", new Object[]{this.name, hostName, this.boundToPort});
            result.set(null);
            ch.closeFuture().syncUninterruptibly();
        }, this.name).start();
        return result;
    }

    private ServerBootstrap createServerBootstrap() {
        this.bossThreadGroup = new NioEventLoopGroup(this.bossThreads);
        this.workerThreadGroup = new NioEventLoopGroup(this.workerThreads);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(this.bossThreadGroup, this.workerThreadGroup);
        this.setOptions(bootstrap);
        this.initialized.set(true);
        return this.initServerBoostrap(bootstrap);
    }

    private ServerBootstrap initServerBoostrap(ServerBootstrap bootstrap) {
        return ((ServerBootstrap)bootstrap.channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                TcpServer.this.initChildChannel(ch);
            }
        });
    }

    private void initChildChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        for (Map.Entry<String, Supplier<ChannelHandler>> entry : this.handlers.entrySet()) {
            ChannelHandler handler = entry.getValue().get();
            String key = entry.getKey();
            pipeline.addLast(key, handler);
        }
        if (!this.closeFutureListeners.isEmpty()) {
            for (Supplier supplier : this.closeFutureListeners) {
                ChannelFutureListener cfl = (ChannelFutureListener)supplier.get();
                ch.closeFuture().addListener((GenericFutureListener)cfl);
            }
        }
    }

    private void setOptions(ServerBootstrap bootstrap) {
        Object value;
        ChannelOption key;
        Object channelOptions = this.options.get();
        Object childChannelOptions = this.childOptions.get();
        for (Map.Entry entry : channelOptions.entrySet()) {
            key = (ChannelOption)entry.getKey();
            value = entry.getValue();
            bootstrap.option(key, value);
        }
        for (Map.Entry entry : childChannelOptions.entrySet()) {
            key = (ChannelOption)entry.getKey();
            value = entry.getValue();
            bootstrap.childOption(key, value);
        }
    }

    private TcpServer checkState() {
        if (this.initialized.get()) {
            throw new IllegalStateException("Server already initialized");
        }
        return this;
    }
}

