/*
 * Decompiled with CFR 0.152.
 */
package org.kgusarov.integration.spring.netty;

import com.google.common.util.concurrent.Futures;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.kgusarov.integration.spring.netty.TcpServer;
import org.kgusarov.integration.spring.netty.configuration.NettyServers;
import org.springframework.beans.factory.BeanInitializationException;

public class TcpServerLifeCycle {
    private final NettyServers nettyServers;

    public TcpServerLifeCycle(NettyServers nettyServers) {
        this.nettyServers = nettyServers;
    }

    @PostConstruct
    public void start() {
        try {
            List startFutures = this.nettyServers.stream().map(TcpServer::start).collect(Collectors.toList());
            Futures.allAsList(startFutures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BeanInitializationException("Failed to start NETTY servers", (Throwable)e);
        }
    }

    @PreDestroy
    public void stop() {
        this.nettyServers.forEach(TcpServer::stop);
    }
}

