/*
 * Decompiled with CFR 0.152.
 */
package org.kgusarov.integration.spring.netty.support;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.kgusarov.integration.spring.netty.support.invoke.OnConnectMethodInvoker;
import org.kgusarov.integration.spring.netty.support.invoke.OnMessageMethodInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringChannelHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringChannelHandler.class);
    private final List<OnConnectMethodInvoker> onConnectCallbacks;
    private final List<OnMessageMethodInvoker> onMessageCallbacks;
    private final ListMultimap<Class<?>, OnMessageMethodInvoker> typedCallbackMap;
    private final Set<Class<?>> typedCallbackClasses;

    public SpringChannelHandler(List<OnConnectMethodInvoker> onConnectCallbacks, List<OnMessageMethodInvoker> onMessageCallbacks) {
        this.onConnectCallbacks = onConnectCallbacks;
        this.onMessageCallbacks = onMessageCallbacks;
        ArrayListMultimap onMessageInvokers = ArrayListMultimap.create();
        Set<Class> messageBodyTypes = onMessageCallbacks.stream().map(OnMessageMethodInvoker::getMessageBodyType).filter(Objects::nonNull).collect(Collectors.toSet());
        messageBodyTypes.forEach(arg_0 -> SpringChannelHandler.lambda$new$1(onMessageCallbacks, (Multimap)onMessageInvokers, arg_0));
        this.typedCallbackMap = ImmutableListMultimap.copyOf((Multimap)onMessageInvokers);
        this.typedCallbackClasses = this.typedCallbackMap.keySet();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.onConnectCallbacks.forEach(cb -> cb.channelActive(ctx));
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Class<?> messageClass = msg.getClass();
        List<OnMessageMethodInvoker> callbacks = this.typedCallbackClasses.stream().filter(clazz -> clazz.isAssignableFrom(messageClass)).findFirst().map(arg_0 -> this.typedCallbackMap.get(arg_0)).orElse(this.onMessageCallbacks);
        boolean processed = callbacks.stream().map(cb -> cb.channelRead(ctx, msg)).reduce(false, (a, b) -> a != false || b != false);
        if (!processed) {
            LOGGER.warn("Message " + msg + " was not processed by any handler");
        }
        super.channelRead(ctx, msg);
    }

    private static /* synthetic */ void lambda$new$1(List onMessageCallbacks, Multimap onMessageInvokers, Class mbt) {
        onMessageCallbacks.forEach(invoker -> {
            Class<?> messageBodyType = invoker.getMessageBodyType();
            if (messageBodyType == null || mbt.isAssignableFrom(messageBodyType)) {
                onMessageInvokers.put((Object)mbt, invoker);
            }
        });
    }
}

