/*
 * Decompiled with CFR 0.152.
 */
package org.kgusarov.integration.spring.netty.support.invoke;

import com.google.common.primitives.Primitives;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kgusarov.integration.spring.netty.annotations.NettyMessageBody;
import org.kgusarov.integration.spring.netty.support.invoke.AbstractMethodInvoker;
import org.kgusarov.integration.spring.netty.support.resolvers.NettyOnMessageParameterResolver;
import org.springframework.core.MethodParameter;

public final class OnMessageMethodInvoker
extends AbstractMethodInvoker {
    private final List<NettyOnMessageParameterResolver> parameterResolvers;
    private final Class<?> messageBodyType;

    public OnMessageMethodInvoker(Object bean, Method method, List<NettyOnMessageParameterResolver> parameterResolvers, boolean sendResult) {
        super(bean, method, sendResult);
        this.parameterResolvers = parameterResolvers;
        int parameterCount = method.getParameterCount();
        List messageBodyArgs = IntStream.range(0, parameterCount).mapToObj(i -> new MethodParameter(method, i)).filter(mp -> mp.hasParameterAnnotation(NettyMessageBody.class)).collect(Collectors.toList());
        if (messageBodyArgs.size() > 1) {
            throw new IllegalArgumentException(method + " has more than one NettyMessageBody annotated parameters");
        }
        this.messageBodyType = Optional.ofNullable(messageBodyArgs.size() == 1 ? ((MethodParameter)messageBodyArgs.get(0)).getParameterType() : null).map(c -> c.isPrimitive() ? Primitives.wrap((Class)c) : c).orElse(null);
    }

    public Class<?> getMessageBodyType() {
        return this.messageBodyType;
    }

    public boolean channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.messageBodyType != null && !this.messageBodyType.isAssignableFrom(msg.getClass())) {
            return false;
        }
        Function<NettyOnMessageParameterResolver, @Nullable Object> fn = pr -> pr.resolve(ctx, msg);
        Object[] args = this.parameterResolvers.stream().map(fn).toArray();
        Channel channel = ctx.channel();
        this.invokeHandler(channel, args);
        return true;
    }
}

