/*
 * Decompiled with CFR 0.152.
 */
package org.kgusarov.integration.spring.netty;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;
import java.util.function.Supplier;

public final class ChannelOptions
implements Supplier<Map<ChannelOption, Object>> {
    private final Map<ChannelOption, Object> options = Maps.newHashMap();

    public void setAllocator(ByteBufAllocator allocator) {
        this.options.put(ChannelOption.ALLOCATOR, allocator);
    }

    public void setRecvBufAllocator(RecvByteBufAllocator allocator) {
        this.options.put(ChannelOption.RCVBUF_ALLOCATOR, allocator);
    }

    public void setConnectTimeout(int milliseconds) {
        this.options.put(ChannelOption.CONNECT_TIMEOUT_MILLIS, milliseconds);
    }

    public void setWriteSpinCount(int count) {
        this.options.put(ChannelOption.WRITE_SPIN_COUNT, count);
    }

    public void setWriteBufferWaterMark(WriteBufferWaterMark mark) {
        this.options.put(ChannelOption.WRITE_BUFFER_WATER_MARK, mark);
    }

    public void setAllowHalfClosure(boolean allow) {
        this.options.put(ChannelOption.ALLOW_HALF_CLOSURE, allow);
    }

    public void setAutoRead(boolean autoRead) {
        this.options.put(ChannelOption.AUTO_READ, autoRead);
    }

    public void setSoBroadcast(boolean broadcast) {
        this.options.put(ChannelOption.SO_BROADCAST, broadcast);
    }

    public void setSoKeepAlive(boolean keepAlive) {
        this.options.put(ChannelOption.SO_KEEPALIVE, keepAlive);
    }

    public void setSoSndBuf(int buf) {
        this.options.put(ChannelOption.SO_SNDBUF, buf);
    }

    public void setSoRcvBuf(int buf) {
        this.options.put(ChannelOption.SO_RCVBUF, buf);
    }

    public void setSoReuseAddr(boolean reuseAddr) {
        this.options.put(ChannelOption.SO_REUSEADDR, reuseAddr);
    }

    public void setSoLinger(int linger) {
        this.options.put(ChannelOption.SO_LINGER, linger);
    }

    public void setSoBacklog(int backlog) {
        this.options.put(ChannelOption.SO_BACKLOG, backlog);
    }

    public void setSoTimeout(int timeout) {
        this.options.put(ChannelOption.SO_TIMEOUT, timeout);
    }

    public void setIpTos(int tos) {
        this.options.put(ChannelOption.IP_TOS, tos);
    }

    public void setIpMulticastAddr(InetAddress addr) {
        this.options.put(ChannelOption.IP_MULTICAST_ADDR, addr);
    }

    public void setIpMulticastIf(NetworkInterface iface) {
        this.options.put(ChannelOption.IP_MULTICAST_IF, iface);
    }

    public void setIpMulticastTtl(int ttl) {
        this.options.put(ChannelOption.IP_MULTICAST_TTL, ttl);
    }

    public void setIpMulticastLoopDisabled(boolean loopDisabled) {
        this.options.put(ChannelOption.IP_MULTICAST_LOOP_DISABLED, loopDisabled);
    }

    public void setTcpNodelay(boolean noDelay) {
        this.options.put(ChannelOption.TCP_NODELAY, noDelay);
    }

    @Override
    public Map<ChannelOption, Object> get() {
        return this.options;
    }
}

