/*
 * Decompiled with CFR 0.152.
 */
package org.kgusarov.integration.spring.netty.configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.kgusarov.integration.spring.netty.ChannelOptions;
import org.kgusarov.integration.spring.netty.TcpServer;
import org.kgusarov.integration.spring.netty.TcpServerLifeCycle;
import org.kgusarov.integration.spring.netty.annotations.NettyController;
import org.kgusarov.integration.spring.netty.annotations.NettyFilter;
import org.kgusarov.integration.spring.netty.annotations.NettyOnConnect;
import org.kgusarov.integration.spring.netty.annotations.NettyOnDisconnect;
import org.kgusarov.integration.spring.netty.annotations.NettyOnMessage;
import org.kgusarov.integration.spring.netty.configuration.NettyServers;
import org.kgusarov.integration.spring.netty.configuration.SpringNettyConfigurationProperties;
import org.kgusarov.integration.spring.netty.configuration.TcpServerProperties;
import org.kgusarov.integration.spring.netty.support.SpringChannelFutureListener;
import org.kgusarov.integration.spring.netty.support.SpringChannelHandler;
import org.kgusarov.integration.spring.netty.support.invoke.OnConnectMethodInvoker;
import org.kgusarov.integration.spring.netty.support.invoke.OnDisconnectMethodInvoker;
import org.kgusarov.integration.spring.netty.support.invoke.OnMessageMethodInvoker;
import org.kgusarov.integration.spring.netty.support.resolvers.NettyCallbackParameterResolver;
import org.kgusarov.integration.spring.netty.support.resolvers.NettyOnConnectParameterResolver;
import org.kgusarov.integration.spring.netty.support.resolvers.NettyOnDisconnectParameterResolver;
import org.kgusarov.integration.spring.netty.support.resolvers.NettyOnMessageParameterResolver;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@ComponentScan(basePackageClasses={SpringChannelHandler.class})
@EnableConfigurationProperties(value={SpringNettyConfigurationProperties.class})
public class SpringNettyConfiguration {
    @VisibleForTesting
    static final Comparator<Method> ON_CONNECT_METHOD_COMPARATOR = Comparator.comparingInt(m -> {
        NettyOnConnect ann = (NettyOnConnect)AnnotationUtils.findAnnotation((Method)m, NettyOnConnect.class);
        if (ann == null) {
            throw new IllegalStateException();
        }
        return ann.priority();
    });
    @VisibleForTesting
    static final Comparator<Method> ON_DISCONNECT_METHOD_COMPARATOR = Comparator.comparingInt(m -> {
        NettyOnDisconnect ann = (NettyOnDisconnect)AnnotationUtils.findAnnotation((Method)m, NettyOnDisconnect.class);
        if (ann == null) {
            throw new IllegalStateException();
        }
        return ann.priority();
    });
    @VisibleForTesting
    static final Comparator<Method> ON_MESSAGE_METHOD_COMPARATOR = Comparator.comparingInt(m -> {
        NettyOnMessage ann = (NettyOnMessage)AnnotationUtils.findAnnotation((Method)m, NettyOnMessage.class);
        if (ann == null) {
            throw new IllegalStateException();
        }
        return ann.priority();
    });
    @VisibleForTesting
    static final Comparator<Object> FILTER_BEAN_COMPARATOR = Comparator.comparingInt(o -> {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)o);
        NettyFilter ann = (NettyFilter)AnnotationUtils.findAnnotation((Class)clazz, NettyFilter.class);
        if (ann == null) {
            throw new IllegalStateException();
        }
        return ann.priority();
    });
    private final SpringNettyConfigurationProperties configurationProperties;
    private final ConfigurableListableBeanFactory beanFactory;

    @Autowired
    public SpringNettyConfiguration(SpringNettyConfigurationProperties configurationProperties, ConfigurableListableBeanFactory beanFactory) {
        this.configurationProperties = configurationProperties;
        this.beanFactory = beanFactory;
    }

    @Bean
    public TcpServerLifeCycle tcpServerLifeCycle() {
        NettyServers nettyServers = this.tcpServers();
        return new TcpServerLifeCycle(nettyServers);
    }

    @Bean
    public NettyServers tcpServers() {
        List<TcpServerProperties> servers = this.configurationProperties.getServers();
        NettyServers result = new NettyServers();
        if (servers == null) {
            return result;
        }
        HashMap<String, List<Method>> connectHandlers = new HashMap<String, List<Method>>();
        HashMap<String, List<Method>> disconnectHandlers = new HashMap<String, List<Method>>();
        HashMap<String, List<Method>> messageHandlers = new HashMap<String, List<Method>>();
        this.fillControllerHandlers(connectHandlers, disconnectHandlers, messageHandlers);
        Map filters = this.beanFactory.getBeansWithAnnotation(NettyFilter.class);
        HashBiMap filterBeans = HashBiMap.create((Map)filters);
        Map<String, List<ChannelHandler>> filterHandlers = this.buildFilterHandlers(filters);
        SpringNettyConfiguration.validateConfiguration(servers, connectHandlers, disconnectHandlers, messageHandlers, filterHandlers);
        Collection<NettyOnConnectParameterResolver> connectParameterResolvers = this.beanFactory.getBeansOfType(NettyOnConnectParameterResolver.class).values();
        Collection<NettyOnDisconnectParameterResolver> disconnectParameterResolvers = this.beanFactory.getBeansOfType(NettyOnDisconnectParameterResolver.class).values();
        Collection<NettyOnMessageParameterResolver> messageParameterResolvers = this.beanFactory.getBeansOfType(NettyOnMessageParameterResolver.class).values();
        for (TcpServerProperties serverProperties : servers) {
            String name = serverProperties.getName();
            TcpServer server = this.buildTcpServer(serverProperties, name);
            List<OnConnectMethodInvoker> onConnectMethodInvokers = this.buildConnectMethodInvokers(name, connectHandlers, connectParameterResolvers);
            List<OnDisconnectMethodInvoker> onDisconnectMethodInvokers = this.buildDisconnectMethodInvokers(name, disconnectHandlers, disconnectParameterResolvers);
            List<OnMessageMethodInvoker> onMessageMethodInvokers = this.buildMessageMethodInvokers(name, messageHandlers, messageParameterResolvers);
            List<Supplier<ChannelHandler>> filterSuppliers = this.buildFilterSuppliers((BiMap<String, Object>)filterBeans, filterHandlers, name);
            AtomicInteger counter = new AtomicInteger(0);
            filterSuppliers.forEach(s -> {
                String nettyHandlerName = "filter" + counter.incrementAndGet();
                server.addHandler(nettyHandlerName, (Supplier<ChannelHandler>)s);
            });
            server.addHandler("springNettyHandler", () -> new SpringChannelHandler(onConnectMethodInvokers, onMessageMethodInvokers));
            server.onDisconnect(() -> new SpringChannelFutureListener(onDisconnectMethodInvokers));
            result.add(server);
        }
        return result;
    }

    private Map<String, List<ChannelHandler>> buildFilterHandlers(Map<String, Object> filters) {
        HashMap<String, List<ChannelHandler>> filterHandlers = new HashMap<String, List<ChannelHandler>>();
        filters.forEach((ignored, bean) -> {
            Class beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
            if (!ChannelHandler.class.isAssignableFrom(beanClass)) {
                throw new IllegalStateException("Bean annotated with @NettyFilter doesn't implement ChannelHandler: " + bean);
            }
            NettyFilter annotation = (NettyFilter)AnnotationUtils.findAnnotation((Class)beanClass, NettyFilter.class);
            if (annotation != null) {
                String serverName = annotation.serverName();
                filterHandlers.computeIfAbsent(serverName, k -> new ArrayList()).add((ChannelHandler)bean);
            }
        });
        filterHandlers.values().forEach(l -> l.sort(FILTER_BEAN_COMPARATOR));
        return filterHandlers;
    }

    private List<Supplier<ChannelHandler>> buildFilterSuppliers(BiMap<String, Object> filterBeans, Map<String, List<ChannelHandler>> filterHandlers, String name) {
        return ((List)filterHandlers.getOrDefault(name, new ArrayList())).stream().map(o -> {
            Scope scope;
            Class beanClass = AopProxyUtils.ultimateTargetClass((Object)o);
            ChannelHandler.Sharable sharable = (ChannelHandler.Sharable)AnnotationUtils.findAnnotation((Class)beanClass, ChannelHandler.Sharable.class);
            if (!(sharable != null || (scope = (Scope)AnnotationUtils.findAnnotation((Class)beanClass, Scope.class)) != null && "prototype".equals(scope.value()))) {
                throw new IllegalStateException("Non-sharable handler should be presented by a prototype bean");
            }
            String beanName = (String)filterBeans.inverse().get(o);
            Supplier<ChannelHandler> beanSupplier = sharable == null ? () -> (ChannelHandler)this.beanFactory.getBean(beanName, beanClass) : () -> o;
            return beanSupplier;
        }).collect(Collectors.toList());
    }

    private TcpServer buildTcpServer(TcpServerProperties serverProperties, String name) {
        Integer bossThreads = serverProperties.getBossThreads();
        Integer workerThreads = serverProperties.getWorkerThreads();
        ChannelOptions childOptions = serverProperties.getChildOptions();
        ChannelOptions options = serverProperties.getOptions();
        String host = serverProperties.getHost();
        Integer port = serverProperties.getPort();
        TcpServer server = new TcpServer(name);
        server.setHost(host);
        server.setPort(port);
        if (bossThreads != null) {
            server.setBossThreads(bossThreads);
        }
        if (workerThreads != null) {
            server.setWorkerThreads(workerThreads);
        }
        if (options != null) {
            server.setOptions(options);
        }
        if (childOptions != null) {
            server.setChildOptions(childOptions);
        }
        return server;
    }

    private void fillControllerHandlers(Map<String, List<Method>> connectHandlers, Map<String, List<Method>> disconnectHandlers, Map<String, List<Method>> messageHandlers) {
        Map controllers = this.beanFactory.getBeansWithAnnotation(NettyController.class);
        controllers.forEach((ignored, bean) -> {
            Method[] methods;
            Class beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
            for (Method method : methods = ReflectionUtils.getAllDeclaredMethods((Class)beanClass)) {
                long c;
                boolean isHandler;
                boolean isConnectHandler = SpringNettyConfiguration.checkForConnectHandler(connectHandlers, method);
                boolean isDisconnectHandler = SpringNettyConfiguration.checkForDisconnectHandler(disconnectHandlers, method);
                boolean isMessageHandler = SpringNettyConfiguration.checkForMessageHandler(messageHandlers, method);
                boolean bl = isHandler = isConnectHandler || isDisconnectHandler || isMessageHandler;
                if (!isHandler || (c = Stream.of(isConnectHandler, isDisconnectHandler, isMessageHandler).filter(b -> b).count()) == 1L) continue;
                throw new IllegalStateException("Method " + method + " is handler of various events. Currently this is not allowed!");
            }
        });
        connectHandlers.values().forEach(l -> l.sort(ON_CONNECT_METHOD_COMPARATOR));
        disconnectHandlers.values().forEach(l -> l.sort(ON_DISCONNECT_METHOD_COMPARATOR));
        messageHandlers.values().forEach(l -> l.sort(ON_MESSAGE_METHOD_COMPARATOR));
    }

    private List<OnDisconnectMethodInvoker> buildDisconnectMethodInvokers(String serverName, Map<String, List<Method>> disconnectHandlers, Collection<NettyOnDisconnectParameterResolver> disconnectParameterResolvers) {
        List onDisconnect = disconnectHandlers.getOrDefault(serverName, new ArrayList());
        ArrayList<OnDisconnectMethodInvoker> result = new ArrayList<OnDisconnectMethodInvoker>();
        for (Method method : onDisconnect) {
            List<NettyOnDisconnectParameterResolver> resolvers = SpringNettyConfiguration.buildMethodParameterResolvers(method, disconnectParameterResolvers);
            ReflectionUtils.makeAccessible((Method)method);
            Class<?> declaringClass = method.getDeclaringClass();
            Object bean = this.beanFactory.getBean(declaringClass);
            OnDisconnectMethodInvoker invoker = new OnDisconnectMethodInvoker(bean, method, resolvers);
            result.add(invoker);
        }
        return result;
    }

    private List<OnMessageMethodInvoker> buildMessageMethodInvokers(String serverName, Map<String, List<Method>> messageHandlers, Collection<NettyOnMessageParameterResolver> messageParameterResolvers) {
        List onMessage = messageHandlers.getOrDefault(serverName, new ArrayList());
        ArrayList<OnMessageMethodInvoker> result = new ArrayList<OnMessageMethodInvoker>();
        for (Method method : onMessage) {
            List<NettyOnMessageParameterResolver> resolvers = SpringNettyConfiguration.buildMethodParameterResolvers(method, messageParameterResolvers);
            Class<?> returnType = method.getReturnType();
            boolean sendInvocationResultBack = !Void.TYPE.equals(returnType);
            ReflectionUtils.makeAccessible((Method)method);
            Class<?> declaringClass = method.getDeclaringClass();
            Object bean = this.beanFactory.getBean(declaringClass);
            OnMessageMethodInvoker invoker = new OnMessageMethodInvoker(bean, method, resolvers, sendInvocationResultBack);
            result.add(invoker);
        }
        return result;
    }

    private List<OnConnectMethodInvoker> buildConnectMethodInvokers(String serverName, Map<String, List<Method>> connectHandlers, Collection<NettyOnConnectParameterResolver> connectParameterResolvers) {
        List onConnect = connectHandlers.getOrDefault(serverName, new ArrayList());
        ArrayList<OnConnectMethodInvoker> result = new ArrayList<OnConnectMethodInvoker>();
        for (Method method : onConnect) {
            List<NettyOnConnectParameterResolver> resolvers = SpringNettyConfiguration.buildMethodParameterResolvers(method, connectParameterResolvers);
            Class<?> returnType = method.getReturnType();
            boolean sendInvocationResultBack = !Void.TYPE.equals(returnType);
            Class<?> declaringClass = method.getDeclaringClass();
            Object bean = this.beanFactory.getBean(declaringClass);
            OnConnectMethodInvoker invoker = new OnConnectMethodInvoker(bean, method, resolvers, sendInvocationResultBack);
            result.add(invoker);
        }
        return result;
    }

    private static <T extends NettyCallbackParameterResolver> List<T> buildMethodParameterResolvers(Method method, Collection<T> candidates) {
        int parameterCount = method.getParameterCount();
        return IntStream.range(0, parameterCount).mapToObj(i -> new MethodParameter(method, i)).map(methodParameter -> SpringNettyConfiguration.findMethodParameterResolver(candidates, methodParameter)).collect(Collectors.toList());
    }

    private static <T extends NettyCallbackParameterResolver> T findMethodParameterResolver(Collection<T> candidates, MethodParameter methodParameter) {
        return (T)candidates.stream().filter(r -> r.canResolve(methodParameter)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find resolver for " + methodParameter));
    }

    private static boolean checkForConnectHandler(Map<String, List<Method>> connectHandlers, Method method) {
        NettyOnConnect annotation = (NettyOnConnect)AnnotationUtils.findAnnotation((Method)method, NettyOnConnect.class);
        if (annotation != null) {
            String serverName = annotation.serverName();
            connectHandlers.computeIfAbsent(serverName, k -> new ArrayList()).add(method);
            return true;
        }
        return false;
    }

    private static boolean checkForDisconnectHandler(Map<String, List<Method>> disconnectHandlers, Method method) {
        NettyOnDisconnect annotation = (NettyOnDisconnect)AnnotationUtils.findAnnotation((Method)method, NettyOnDisconnect.class);
        if (annotation != null) {
            String serverName = annotation.serverName();
            disconnectHandlers.computeIfAbsent(serverName, k -> new ArrayList()).add(method);
            return true;
        }
        return false;
    }

    private static boolean checkForMessageHandler(Map<String, List<Method>> messageHandlers, Method method) {
        NettyOnMessage annotation = (NettyOnMessage)AnnotationUtils.findAnnotation((Method)method, NettyOnMessage.class);
        if (annotation != null) {
            String serverName = annotation.serverName();
            messageHandlers.computeIfAbsent(serverName, k -> new ArrayList()).add(method);
            return true;
        }
        return false;
    }

    private static void validateConfiguration(List<TcpServerProperties> servers, Map<String, List<Method>> connectHandlers, Map<String, List<Method>> disconnectHandlers, Map<String, List<Method>> messageHandlers, Map<String, List<ChannelHandler>> filterHandlers) {
        Set serversInConfig = servers.stream().map(TcpServerProperties::getName).distinct().collect(Collectors.toSet());
        if (serversInConfig.size() != servers.size()) {
            throw new IllegalStateException("Configuration has duplicate server definitions");
        }
        Set<String> connectServerNames = connectHandlers.keySet();
        Set<String> disconnectServerNames = disconnectHandlers.keySet();
        Set<String> messageServerNames = messageHandlers.keySet();
        Set<String> filterServerNames = filterHandlers.keySet();
        Sets.SetView serversInHandlers = Sets.union((Set)Sets.union(connectServerNames, disconnectServerNames), (Set)Sets.union(messageServerNames, filterServerNames));
        Sets.SetView diff = Sets.symmetricDifference(serversInConfig, (Set)serversInHandlers);
        if (!diff.isEmpty()) {
            throw new IllegalStateException("Handlers are not present both in config and handler beans: " + diff);
        }
    }
}

