/*
 * Decompiled with CFR 0.152.
 */
package org.kgusarov.integration.spring.netty.handlers;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public final class FlashPolicyHandler
extends ChannelInboundHandlerAdapter {
    @VisibleForTesting
    static final String POLICY_FILE_REQUEST = "<policy-file-request/>";
    @VisibleForTesting
    static final String POLICY_FILE_RESPONSE = "<?xml version=\"1.0\"?><!DOCTYPE cross-domain-policy SYSTEM \"/xml/dtds/cross-domain-policy.dtd\"><cross-domain-policy>    <site-control permitted-cross-domain-policies=\"master-only\"/>   <allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>";
    private final ByteBuf requestBuffer = Unpooled.copiedBuffer((CharSequence)"<policy-file-request/>", (Charset)CharsetUtil.UTF_8);
    private final ByteBuf responseBuffer = Unpooled.copiedBuffer((CharSequence)"<?xml version=\"1.0\"?><!DOCTYPE cross-domain-policy SYSTEM \"/xml/dtds/cross-domain-policy.dtd\"><cross-domain-policy>    <site-control permitted-cross-domain-policies=\"master-only\"/>   <allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>", (Charset)CharsetUtil.UTF_8);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf message = (ByteBuf)msg;
            int readableBytes = this.requestBuffer.readableBytes();
            ByteBuf data = message.slice(0, readableBytes);
            if (data.equals((Object)this.requestBuffer)) {
                message.release();
                ChannelFuture f = ctx.writeAndFlush((Object)Unpooled.copiedBuffer((ByteBuf)this.responseBuffer));
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
        ctx.fireChannelRead(msg);
    }
}

