/*
 * Decompiled with CFR 0.152.
 */
package org.kgusarov.integration.spring.netty.support.invoke;

import com.google.common.primitives.Primitives;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kgusarov.integration.spring.netty.annotations.NettyMessageBody;
import org.kgusarov.integration.spring.netty.support.invoke.AbstractMethodInvoker;
import org.kgusarov.integration.spring.netty.support.invoke.InvokerMethods;
import org.kgusarov.integration.spring.netty.support.invoke.assembler.Descriptors;
import org.kgusarov.integration.spring.netty.support.resolvers.NettyOnMessageParameterResolver;
import org.springframework.core.MethodParameter;

public final class OnMessageMethodInvoker
extends AbstractMethodInvoker {
    private final Invoker invoker;
    private final Class<?> messageBodyType;

    public OnMessageMethodInvoker(Object bean, Method method, List<NettyOnMessageParameterResolver> parameterResolvers, boolean sendResult) {
        int parameterCount = method.getParameterCount();
        List messageBodyArgs = IntStream.range(0, parameterCount).mapToObj(i -> new MethodParameter(method, i)).filter(mp -> mp.hasParameterAnnotation(NettyMessageBody.class)).collect(Collectors.toList());
        if (messageBodyArgs.size() > 1) {
            throw new IllegalArgumentException(method + " has more than one NettyMessageBody annotated parameters");
        }
        this.messageBodyType = Optional.ofNullable(messageBodyArgs.size() == 1 ? ((MethodParameter)messageBodyArgs.get(0)).getParameterType() : null).map(c -> c.isPrimitive() ? Primitives.wrap((Class)c) : c).orElse(null);
        this.invoker = (Invoker)this.buildInvoker(Invoker.class, method, InvokerMethods.ONM_INVOKE_HANDLER, sendResult, (invokerInternalName, m, firstVarIdx) -> {
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                m.visitIntInsn(25, 0);
                m.visitFieldInsn(180, invokerInternalName, "resolvers", Descriptors.ONM_RESA_DESCRIPTOR);
                m.visitIntInsn(16, i);
                m.visitInsn(50);
                m.visitIntInsn(25, 2);
                m.visitIntInsn(25, 3);
                m.visitMethodInsn(185, Descriptors.ONM_RES_INTERNAL_NAME, "resolve", Descriptors.ONM_RESOLVE_DESCRIPTOR, true);
                m.visitIntInsn(58, firstVarIdx + i);
            }
        });
        this.invoker.bean = bean;
        this.invoker.resolvers = parameterResolvers.toArray(new NettyOnMessageParameterResolver[0]);
    }

    public Class<?> getMessageBodyType() {
        return this.messageBodyType;
    }

    public boolean channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.messageBodyType != null && !this.messageBodyType.isAssignableFrom(msg.getClass())) {
            return false;
        }
        Channel channel = ctx.channel();
        this.invoker.invokeHandler(channel, ctx, msg);
        return true;
    }

    static abstract class Invoker
    extends AbstractMethodInvoker.InvokerBase {
        NettyOnMessageParameterResolver[] resolvers;

        Invoker() {
        }

        abstract void invokeHandler(Channel var1, ChannelHandlerContext var2, Object var3);
    }
}

