/*
 * Decompiled with CFR 0.152.
 */
package org.kgusarov.integration.spring.netty.support.invoke.assembler;

import io.netty.channel.Channel;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.kgusarov.integration.spring.netty.support.invoke.assembler.Descriptors;
import org.kgusarov.integration.spring.netty.support.invoke.assembler.LabelAssembler;
import org.kgusarov.integration.spring.netty.support.invoke.assembler.LocalVariableAssembler;
import org.kgusarov.integration.spring.netty.support.invoke.assembler.MethodPrefixAssembler;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class InvokerMethodAssembler {
    private InvokerMethodAssembler() {
    }

    public static void assembleInvokerMethod(ClassWriter cw, String invokerDescriptor, String invokerInternalName, Method invokerMethod, Method targetMethod, boolean sendResult, MethodPrefixAssembler prefixAssembler) {
        String methodDescriptor = Type.getMethodDescriptor((Method)invokerMethod);
        String methodName = invokerMethod.getName();
        MethodVisitor m = cw.visitMethod(1, methodName, methodDescriptor, null, null);
        Label ms = LabelAssembler.createLabel();
        Label me = LabelAssembler.createLabel();
        m.visitCode();
        m.visitLabel(ms);
        Parameter[] invokeParameters = invokerMethod.getParameters();
        int resultIdx = LocalVariableAssembler.getResultIdx(invokeParameters);
        int firstVarIdx = LocalVariableAssembler.getFirstVarIdx(invokeParameters, sendResult);
        prefixAssembler.assemble(invokerInternalName, m, firstVarIdx);
        m.visitFieldInsn(178, invokerInternalName, "HANDLE", Descriptors.MH_DESCRIPTOR);
        m.visitIntInsn(25, 0);
        m.visitFieldInsn(180, invokerInternalName, "bean", Descriptors.OBJ_DESCRIPTOR);
        Parameter[] targetMethodParameters = targetMethod.getParameters();
        for (int i2 = 0; i2 < targetMethodParameters.length; ++i2) {
            m.visitIntInsn(25, i2 + firstVarIdx);
        }
        Object[] paramDescriptors = new String[targetMethodParameters.length + 1];
        Arrays.fill(paramDescriptors, Descriptors.OBJ_DESCRIPTOR);
        String tmd = '(' + String.join((CharSequence)"", (CharSequence[])paramDescriptors) + ')' + Descriptors.OBJ_DESCRIPTOR;
        m.visitMethodInsn(182, Descriptors.MH_INTERNAL_NAME, "invokeExact", tmd, false);
        if (sendResult) {
            int channelArgIdx = IntStream.range(0, invokeParameters.length).filter(i -> {
                Parameter parameter = invokeParameters[i];
                Class<?> type = parameter.getType();
                return Channel.class.isAssignableFrom(type);
            }).findFirst().orElse(-2) + 1;
            m.visitIntInsn(58, resultIdx);
            m.visitIntInsn(25, channelArgIdx);
            m.visitIntInsn(25, resultIdx);
            m.visitMethodInsn(185, Descriptors.CHANNEL_INTERNAL_NAME, "writeAndFlush", Descriptors.CHANNEL_WRITE_AND_FLUSH_DESCRIPTOR, true);
        }
        m.visitInsn(87);
        m.visitInsn(177);
        m.visitLabel(me);
        LocalVariableAssembler.assembleLocalVariables(m, ms, me, invokerDescriptor, invokeParameters, targetMethodParameters, sendResult);
        m.visitEnd();
        m.visitMaxs(0, 0);
    }
}

