/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.services.cdi;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.inject.Singleton;
import org.kie.commons.services.cdi.Startup;
import org.kie.commons.services.cdi.StartupType;

public class StartupBeanExtension
implements Extension {
    private final List<OrderedBean> startupEagerBeans = new LinkedList<OrderedBean>();
    private final List<OrderedBean> startupBootstrapBeans = new LinkedList<OrderedBean>();
    private final Comparator<OrderedBean> priorityComparator = new Comparator<OrderedBean>(){

        @Override
        public int compare(OrderedBean o1, OrderedBean o2) {
            return o1.priority - o2.priority;
        }
    };

    public <X> void processBean(@Observes ProcessBean<X> event) {
        if (event.getAnnotated().isAnnotationPresent(Startup.class) && (event.getAnnotated().isAnnotationPresent(ApplicationScoped.class) || event.getAnnotated().isAnnotationPresent(Singleton.class))) {
            Startup startupAnnotation = (Startup)event.getAnnotated().getAnnotation(Startup.class);
            StartupType type = startupAnnotation.value();
            int priority = startupAnnotation.priority();
            Bean bean = event.getBean();
            switch (type) {
                case EAGER: {
                    this.startupEagerBeans.add(new OrderedBean(bean, priority));
                    break;
                }
                case BOOTSTRAP: {
                    this.startupBootstrapBeans.add(new OrderedBean(bean, priority));
                }
            }
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        this.runPostConstruct(manager, this.startupBootstrapBeans);
        this.runPostConstruct(manager, this.startupEagerBeans);
    }

    private void runPostConstruct(BeanManager manager, List<OrderedBean> orderedBeans) {
        Collections.sort(orderedBeans, this.priorityComparator);
        for (OrderedBean ob : orderedBeans) {
            Bean<?> bean = ob.bean;
            manager.getReference(bean, (Type)bean.getBeanClass(), manager.createCreationalContext(bean)).toString();
        }
    }

    private class OrderedBean {
        Bean<?> bean;
        int priority;

        private OrderedBean(Bean<?> bean, int priority) {
            this.bean = bean;
            this.priority = priority;
        }
    }
}

