/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.file;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.LongAssert;
import org.fest.assertions.api.MapAssert;
import org.fest.assertions.api.ObjectArrayAssert;
import org.fest.assertions.api.ObjectAssert;
import org.junit.Test;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.GeneralFileAttributeView;
import org.kie.commons.java.nio.base.GeneralFileAttributes;
import org.kie.commons.java.nio.base.NotImplementedException;
import org.kie.commons.java.nio.channels.SeekableByteChannel;
import org.kie.commons.java.nio.file.AbstractBaseTest;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.DirectoryNotEmptyException;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.FileSystemNotFoundException;
import org.kie.commons.java.nio.file.FileSystems;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.Paths;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributeView;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributes;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.commons.java.nio.fs.file.BaseSimpleFileStore;
import org.kie.commons.java.nio.fs.jgit.JGitFileStore;

public class FilesTest
extends AbstractBaseTest {
    @Test
    public void newIOStreams() throws java.io.IOException {
        int i;
        Path dir = this.newTempDir();
        OutputStream out = Files.newOutputStream((Path)dir.resolve("file.txt"), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)out).isNotNull();
        out.write("content".getBytes());
        out.close();
        InputStream in = Files.newInputStream((Path)dir.resolve("file.txt"), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((InputStream)in).isNotNull();
        StringBuilder sb = new StringBuilder();
        while ((i = in.read()) != -1) {
            sb.append((char)i);
        }
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"content");
    }

    @Test(expected=NoSuchFileException.class)
    public void newInputStreamNonExistent() {
        Files.newInputStream((Path)Paths.get((String)"/path/to/some/file.txt", (String[])new String[0]), (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void newInputStreamOnDir() {
        Path dir = this.newTempDir();
        Files.newInputStream((Path)dir, (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newInputStreamNull() {
        Files.newInputStream(null, (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IOException.class)
    public void newOutputStreamOnExistent() {
        Path dir = this.newTempDir();
        Files.newOutputStream((Path)dir, (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newOutpurStreamNull() {
        Files.newOutputStream(null, (OpenOption[])new OpenOption[0]);
    }

    @Test
    public void newByteChannel() throws java.io.IOException {
        SeekableByteChannel sbc = Files.newByteChannel((Path)this.newTempDir().resolve("file.temp.txt"), new HashSet(), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Object)sbc).isNotNull();
        sbc.close();
        SeekableByteChannel sbc2 = Files.newByteChannel((Path)this.newTempDir().resolve("file.temp2.txt"), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)sbc).isNotNull();
        sbc.close();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void newByteChannelFileAlreadyExists() {
        Files.newByteChannel((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newByteChannelNull() {
        Files.newByteChannel(null, (OpenOption[])new OpenOption[0]);
    }

    @Test
    public void createFile() throws java.io.IOException {
        Path path = Files.createFile((Path)this.newTempDir().resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createFileAlreadyExists() {
        Files.createFile((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFileNull() {
        Files.createFile(null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test
    public void createDirectory() {
        Path path = this.newTempDir();
        Path dir = Files.createDirectory((Path)path.resolve("myNewDir"), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)dir).isNotNull();
        Assertions.assertThat((boolean)dir.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)dir.toFile().isDirectory()).isTrue();
        Path file = Files.createFile((Path)dir.resolve("new.file.txt"), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)file).isNotNull();
        Assertions.assertThat((boolean)file.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)file.toFile().isDirectory()).isFalse();
        Assertions.assertThat((boolean)file.toFile().isFile()).isTrue();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createDirectoryFileAlreadyExists() {
        Files.createDirectory((Path)this.newTempDir(), (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createDirectoryNull() {
        Files.createDirectory(null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test
    public void createDirectories() {
        Path path = this.newTempDir();
        Path dir = Files.createDirectories((Path)path.resolve("myNewDir/mysubDir1/mysubDir2"), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)dir).isNotNull();
        Assertions.assertThat((boolean)dir.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)dir.toFile().isDirectory()).isTrue();
        Path file = Files.createFile((Path)dir.resolve("new.file.txt"), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)file).isNotNull();
        Assertions.assertThat((boolean)file.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)file.toFile().isDirectory()).isFalse();
        Assertions.assertThat((boolean)file.toFile().isFile()).isTrue();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createDirectoriesFileAlreadyExists() {
        Files.createDirectories((Path)this.newTempDir(), (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createDirectoriesNull() {
        Files.createDirectories(null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test
    public void delete() {
        Path path = Files.createFile((Path)this.newTempDir().resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
        Files.delete((Path)path);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
        Path dir = this.newTempDir();
        Assertions.assertThat((Iterable)dir).isNotNull();
        Assertions.assertThat((boolean)dir.toFile().exists()).isTrue();
        Files.delete((Path)dir);
        Assertions.assertThat((Iterable)dir).isNotNull();
        Assertions.assertThat((boolean)dir.toFile().exists()).isFalse();
    }

    @Test(expected=DirectoryNotEmptyException.class)
    public void deleteDirectoryNotEmpty() {
        Path dir = this.newTempDir();
        Files.createFile((Path)dir.resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        Files.delete((Path)dir);
    }

    @Test(expected=NoSuchFileException.class)
    public void deleteNoSuchFileException() {
        Files.delete((Path)this.newTempDir().resolve("file.temp.txt"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void deleteNull() {
        Files.delete(null);
    }

    @Test
    public void deleteIfExists() {
        Path path = Files.createFile((Path)this.newTempDir().resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)Files.deleteIfExists((Path)path)).isTrue();
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
        Path dir = this.newTempDir();
        Assertions.assertThat((Iterable)dir).isNotNull();
        Assertions.assertThat((boolean)dir.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)Files.deleteIfExists((Path)dir)).isTrue();
        Assertions.assertThat((Iterable)dir).isNotNull();
        Assertions.assertThat((boolean)dir.toFile().exists()).isFalse();
        Assertions.assertThat((boolean)Files.deleteIfExists((Path)this.newTempDir().resolve("file.temp.txt"))).isFalse();
    }

    @Test(expected=DirectoryNotEmptyException.class)
    public void deleteIfExistsDirectoryNotEmpty() {
        Path dir = this.newTempDir();
        Files.createFile((Path)dir.resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        Files.deleteIfExists((Path)dir);
    }

    @Test(expected=IllegalArgumentException.class)
    public void deleteIfExistsNull() {
        Files.deleteIfExists(null);
    }

    @Test
    public void createTempFile() {
        Path tempFile = Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile).isNotNull();
        Assertions.assertThat((String)tempFile.getFileName().toString()).endsWith("tmp");
        Assertions.assertThat((boolean)tempFile.toFile().exists()).isTrue();
        Path tempFile2 = Files.createTempFile((String)"", (String)"", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile2).isNotNull();
        Assertions.assertThat((String)tempFile2.getFileName().toString()).endsWith("tmp");
        Assertions.assertThat((boolean)tempFile2.toFile().exists()).isTrue();
        Path tempFile3 = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile3).isNotNull();
        Assertions.assertThat((boolean)tempFile3.toFile().exists()).isTrue();
        Assertions.assertThat((String)tempFile3.getFileName().toString()).startsWith("foo").endsWith(".bar");
        Path tempFile4 = Files.createTempFile((String)"", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile4).isNotNull();
        Assertions.assertThat((boolean)tempFile4.toFile().exists()).isTrue();
        Assertions.assertThat((String)tempFile4.getFileName().toString()).endsWith(".bar");
        Path tempFile5 = Files.createTempFile((String)"", (String)".bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile5).isNotNull();
        Assertions.assertThat((boolean)tempFile5.toFile().exists()).isTrue();
        Assertions.assertThat((String)tempFile5.getFileName().toString()).endsWith(".bar");
        Path tempFile6 = Files.createTempFile((String)"", (String)"bar.temp", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile6).isNotNull();
        Assertions.assertThat((boolean)tempFile6.toFile().exists()).isTrue();
        Assertions.assertThat((String)tempFile6.getFileName().toString()).endsWith(".bar.temp");
        Path tempFile7 = Files.createTempFile((String)"", (String)".bar.temp", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile7).isNotNull();
        Assertions.assertThat((boolean)tempFile7.toFile().exists()).isTrue();
        Assertions.assertThat((String)tempFile7.getFileName().toString()).endsWith(".bar.temp");
    }

    @Test
    public void createTempFileInsideDir() {
        Path dir = this.newTempDir();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])dir.toFile().list()).isNotNull()).isEmpty();
        Path tempFile = Files.createTempFile((Path)dir, null, null, (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile).isNotNull();
        Assertions.assertThat((String)tempFile.getFileName().toString()).endsWith("tmp");
        Assertions.assertThat((boolean)tempFile.toFile().exists()).isTrue();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])dir.toFile().list()).isNotNull()).isNotEmpty();
    }

    @Test(expected=NoSuchFileException.class)
    public void createTempFileNoSuchFile() {
        Files.createTempFile((Path)Paths.get((String)"/path/to/", (String[])new String[0]), null, null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createTempFileNull() {
        Files.createTempFile((Path)null, null, null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test
    public void createTempDirectory() {
        Path tempFile = Files.createTempDirectory(null, (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile).isNotNull();
        Assertions.assertThat((boolean)tempFile.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)tempFile.toFile().isDirectory()).isTrue();
        Path tempFile2 = Files.createTempDirectory((String)"", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile2).isNotNull();
        Assertions.assertThat((boolean)tempFile2.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)tempFile2.toFile().isDirectory()).isTrue();
        Path tempFile3 = Files.createTempDirectory((String)"foo", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile3).isNotNull();
        Assertions.assertThat((boolean)tempFile3.toFile().exists()).isTrue();
        Assertions.assertThat((String)tempFile3.getFileName().toString()).startsWith("foo");
        Assertions.assertThat((boolean)tempFile3.toFile().isDirectory()).isTrue();
    }

    @Test
    public void createTempDirectoryInsideDir() {
        Path dir = this.newTempDir();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])dir.toFile().list()).isNotNull()).isEmpty();
        Path tempFile = Files.createTempDirectory((Path)dir, null, (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Iterable)tempFile).isNotNull();
        Assertions.assertThat((boolean)tempFile.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)tempFile.toFile().isDirectory()).isTrue();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])dir.toFile().list()).isNotNull()).isNotEmpty();
    }

    @Test(expected=NoSuchFileException.class)
    public void createTempDirectoryNoSuchFile() {
        Files.createTempDirectory((Path)Paths.get((String)"/path/to/", (String[])new String[0]), null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createTempDirectoryNull() {
        Files.createTempDirectory((Path)null, null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test
    public void copyDir() {
        Path source = this.newTempDir();
        Path dest = this.newDirToClean();
        Assertions.assertThat((boolean)source.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)dest.toFile().exists()).isFalse();
        Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        Assertions.assertThat((boolean)dest.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)source.toFile().exists()).isTrue();
    }

    @Test(expected=DirectoryNotEmptyException.class)
    public void copyDirDirectoryNotEmptyException() {
        Path source = this.newTempDir();
        Path dest = this.newDirToClean();
        Files.createTempFile((Path)source, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
    }

    @Test
    public void copyFile() throws java.io.IOException {
        Path dir = this.newTempDir();
        Path source = dir.resolve("temp.txt");
        Path dest = dir.resolve("result.txt");
        OutputStream stream = Files.newOutputStream((Path)source, (OpenOption[])new OpenOption[0]);
        stream.write(97);
        stream.close();
        Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        Assertions.assertThat((boolean)dest.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)source.toFile().exists()).isTrue();
        Assertions.assertThat((long)dest.toFile().length()).isEqualTo(source.toFile().length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void copyFileInvalidSourceAndTarget() throws java.io.IOException {
        Path source = this.newTempDir();
        Path dest = this.newTempDir().resolve("other");
        Path sourceFile = source.resolve("file.txt");
        OutputStream stream = Files.newOutputStream((Path)sourceFile, (OpenOption[])new OpenOption[0]);
        stream.write(97);
        stream.close();
        try {
            Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
            Assertions.fail((String)"source isn't empty");
        }
        catch (Exception ex) {
            // empty catch block
        }
        sourceFile.toFile().delete();
        Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        try {
            Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
            Assertions.fail((String)"dest already exists");
        }
        catch (Exception ex) {
            // empty catch block
        }
        dest.toFile().delete();
        source.toFile().delete();
        try {
            Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
            Assertions.fail((String)"source doesn't exists");
        }
        catch (Exception ex) {}
    }

    @Test(expected=UnsupportedOperationException.class)
    public void copyDifferentProviders() {
        HashMap<String, String> env = new HashMap<String, String>(2);
        env.put("userName", "user");
        env.put("password", "pass");
        URI uri = URI.create("git://test" + System.currentTimeMillis());
        FileSystems.newFileSystem((URI)uri, env);
        Files.copy((Path)Paths.get((URI)uri), (Path)this.newTempDir(), (CopyOption[])new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyNull1() throws java.io.IOException {
        Files.copy((Path)this.newTempDir(), (Path)null, (CopyOption[])new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyNull2() throws java.io.IOException {
        Files.copy((Path)null, (Path)Paths.get((String)"/temp", (String[])new String[0]), (CopyOption[])new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyNull3() throws java.io.IOException {
        Files.copy((Path)null, (Path)null, (CopyOption[])new CopyOption[0]);
    }

    @Test
    public void moveDir() {
        Path source = this.newTempDir();
        Path dest = this.newTempDir().resolve("other");
        Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        Assertions.assertThat((boolean)source.toFile().exists()).isFalse();
        Assertions.assertThat((boolean)dest.toFile().exists()).isTrue();
    }

    @Test
    public void moveFile() throws java.io.IOException {
        Path dir = this.newTempDir();
        Path source = dir.resolve("fileSource.txt");
        Path dest = dir.resolve("fileDest.txt");
        OutputStream stream = Files.newOutputStream((Path)source, (OpenOption[])new OpenOption[0]);
        stream.write(97);
        stream.close();
        long lenght = source.toFile().length();
        Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        Assertions.assertThat((boolean)dest.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)source.toFile().exists()).isFalse();
        Assertions.assertThat((long)dest.toFile().length()).isEqualTo(lenght);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void moveFileInvalidSourceAndTarget() throws java.io.IOException {
        Path source = this.newTempDir();
        Path dest = this.newTempDir().resolve("other");
        Path sourceFile = source.resolve("file.txt");
        OutputStream stream = Files.newOutputStream((Path)sourceFile, (OpenOption[])new OpenOption[0]);
        stream.write(97);
        stream.close();
        try {
            Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
            Assertions.fail((String)"source isn't empty");
        }
        catch (Exception ex) {
            // empty catch block
        }
        sourceFile.toFile().delete();
        Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        try {
            Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
            Assertions.fail((String)"dest already exists");
        }
        catch (Exception ex) {
            // empty catch block
        }
        dest.toFile().delete();
        source.toFile().delete();
        try {
            Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
            Assertions.fail((String)"source doesn't exists");
        }
        catch (Exception ex) {}
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveNull1() throws java.io.IOException {
        Files.move((Path)this.newTempDir(), null, (CopyOption[])new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveNull2() throws java.io.IOException {
        Files.move(null, (Path)this.newTempDir(), (CopyOption[])new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveNull3() throws java.io.IOException {
        Files.move(null, null, (CopyOption[])new CopyOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void moveDifferentProviders() {
        HashMap<String, String> env = new HashMap<String, String>(2);
        env.put("userName", "user");
        env.put("password", "pass");
        FileSystems.newFileSystem((URI)URI.create("git://testXXXXXXX"), env);
        Files.move((Path)Paths.get((URI)URI.create("git://testXXXXXXX")), (Path)this.newTempDir(), (CopyOption[])new CopyOption[0]);
    }

    @Test
    public void getFileStore() {
        ((ObjectAssert)Assertions.assertThat((Object)Files.getFileStore((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isNotNull()).isInstanceOf(BaseSimpleFileStore.class);
        HashMap<String, String> env = new HashMap<String, String>(2);
        env.put("userName", "user");
        env.put("password", "pass");
        String repoName = "git://testXXXXXXX" + System.currentTimeMillis();
        URI uri = URI.create(repoName);
        FileSystems.newFileSystem((URI)uri, env);
        ((ObjectAssert)Assertions.assertThat((Object)Files.getFileStore((Path)Paths.get((URI)uri))).isNotNull()).isInstanceOf(JGitFileStore.class);
        URI fetch = URI.create(repoName + "?fetch");
        FileSystems.getFileSystem((URI)fetch);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileStoreNull() {
        Files.getFileStore(null);
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void getFileStoreN() {
        URI uri = URI.create("nothing:///testXXXXXXX");
        Files.getFileStore((Path)Paths.get((URI)uri));
    }

    @Test
    public void getFileAttributeViewGeneral() throws java.io.IOException {
        Path path = Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]);
        GeneralFileAttributeView view = (GeneralFileAttributeView)Files.getFileAttributeView((Path)path, GeneralFileAttributeView.class, (LinkOption[])new LinkOption[0]);
        Assertions.assertThat((Object)view).isNotNull();
        Assertions.assertThat((Object)view.readAttributes()).isNotNull();
        Assertions.assertThat((boolean)view.readAttributes().isRegularFile()).isTrue();
        Assertions.assertThat((boolean)view.readAttributes().isDirectory()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isOther()).isFalse();
        Assertions.assertThat((long)view.readAttributes().size()).isEqualTo(0L);
    }

    @Test
    public void getFileAttributeViewBasic() throws java.io.IOException {
        Path path = Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]);
        BasicFileAttributeView view = (BasicFileAttributeView)Files.getFileAttributeView((Path)path, BasicFileAttributeView.class, (LinkOption[])new LinkOption[0]);
        Assertions.assertThat((Object)view).isNotNull();
        Assertions.assertThat((Object)view.readAttributes()).isNotNull();
        Assertions.assertThat((boolean)view.readAttributes().isRegularFile()).isTrue();
        Assertions.assertThat((boolean)view.readAttributes().isDirectory()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isOther()).isFalse();
        Assertions.assertThat((long)view.readAttributes().size()).isEqualTo(0L);
    }

    @Test
    public void getFileAttributeViewInvalidView() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Object)Files.getFileAttributeView((Path)path, MyAttrsView.class, (LinkOption[])new LinkOption[0])).isNull();
    }

    @Test(expected=NoSuchFileException.class)
    public void getFileAttributeViewNoSuchFileException() throws java.io.IOException {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Files.getFileAttributeView((Path)path, BasicFileAttributeView.class, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileAttributeViewNull1() throws java.io.IOException {
        Files.getFileAttributeView(null, MyAttrsView.class, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileAttributeViewNull2() throws java.io.IOException {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Files.getFileAttributeView((Path)path, null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileAttributeViewNull3() throws java.io.IOException {
        Files.getFileAttributeView(null, null, (LinkOption[])new LinkOption[0]);
    }

    @Test
    public void readAttributesGeneral() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        GeneralFileAttributes attrs = (GeneralFileAttributes)Files.readAttributes((Path)path, GeneralFileAttributes.class, (LinkOption[])new LinkOption[0]);
        Assertions.assertThat((Object)attrs).isNotNull();
        Assertions.assertThat((boolean)attrs.isRegularFile()).isTrue();
        Assertions.assertThat((boolean)attrs.isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)attrs.isOther()).isFalse();
        Assertions.assertThat((long)attrs.size()).isEqualTo(0L);
    }

    @Test
    public void readAttributesBasic() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        BasicFileAttributes attrs = Files.readAttributes((Path)path, BasicFileAttributes.class, (LinkOption[])new LinkOption[0]);
        Assertions.assertThat((Object)attrs).isNotNull();
        Assertions.assertThat((boolean)attrs.isRegularFile()).isTrue();
        Assertions.assertThat((boolean)attrs.isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)attrs.isOther()).isFalse();
        Assertions.assertThat((long)attrs.size()).isEqualTo(0L);
    }

    @Test(expected=NoSuchFileException.class)
    public void readAttributesNonExistentFile() throws java.io.IOException {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Files.readAttributes((Path)path, BasicFileAttributes.class, (LinkOption[])new LinkOption[0]);
    }

    @Test
    public void readAttributesInvalid() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Object)Files.readAttributes((Path)path, MyAttrs.class, (LinkOption[])new LinkOption[0])).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesNull1() throws java.io.IOException {
        Files.readAttributes(null, MyAttrs.class, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesNull2() throws java.io.IOException {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Files.readAttributes((Path)path, (Class)null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesNull3() throws java.io.IOException {
        Files.readAttributes(null, (Class)null, (LinkOption[])new LinkOption[0]);
    }

    @Test
    public void readAttributesMap() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"*", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(12);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:*", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(12);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:isRegularFile", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:isRegularFile,isDirectory", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:isRegularFile,isDirectory,someThing", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:someThing", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"isRegularFile", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"isRegularFile,isDirectory", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"isRegularFile,isDirectory,someThing", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"someThing", (LinkOption[])new LinkOption[0])).isNotNull()).hasSize(0);
        try {
            Files.readAttributes((Path)path, (String)":someThing", (LinkOption[])new LinkOption[0]);
            Assertions.fail((String)"undefined view");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            Files.readAttributes((Path)path, (String)"advanced:isRegularFile", (LinkOption[])new LinkOption[0]);
            Assertions.fail((String)"undefined view");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesMapNull1() throws java.io.IOException {
        Files.readAttributes(null, (String)"*", (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesMapNull2() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.readAttributes((Path)path, (String)null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesMapNull3() throws java.io.IOException {
        Files.readAttributes(null, (String)null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesMapEmpty() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.readAttributes((Path)path, (String)"", (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void readAttributesMapNoSuchFileException() throws java.io.IOException {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Files.readAttributes((Path)path, (String)"*", (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeNull1() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.setAttribute((Path)path, null, null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeNull2() throws java.io.IOException {
        Files.setAttribute(null, (String)"some", null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeNull3() throws java.io.IOException {
        Files.setAttribute(null, null, null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeEmpty() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.setAttribute((Path)path, (String)"", null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void setAttributeInvalidAttr() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.setAttribute((Path)path, (String)"myattr", null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void setAttributeInvalidView() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.setAttribute((Path)path, (String)"advanced:isRegularFile", null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeInvalidView2() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.setAttribute((Path)path, (String)":isRegularFile", null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=NotImplementedException.class)
    public void setAttributeNotImpl() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.setAttribute((Path)path, (String)"isRegularFile", null, (LinkOption[])new LinkOption[0]);
    }

    @Test
    public void readAttribute() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Object)Files.getAttribute((Path)path, (String)"basic:isRegularFile", (LinkOption[])new LinkOption[0])).isNotNull();
        Assertions.assertThat((Object)Files.getAttribute((Path)path, (String)"basic:someThing", (LinkOption[])new LinkOption[0])).isNull();
        Assertions.assertThat((Object)Files.getAttribute((Path)path, (String)"isRegularFile", (LinkOption[])new LinkOption[0])).isNotNull();
        Assertions.assertThat((Object)Files.getAttribute((Path)path, (String)"someThing", (LinkOption[])new LinkOption[0])).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributeInvalid() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Object)Files.getAttribute((Path)path, (String)"*", (LinkOption[])new LinkOption[0])).isNotNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributeInvalid2() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Object)Files.getAttribute((Path)path, (String)"isRegularFile,isDirectory", (LinkOption[])new LinkOption[0])).isNull();
    }

    @Test(expected=NoSuchFileException.class)
    public void readAttributeInvalid3() throws java.io.IOException {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Files.getAttribute((Path)path, (String)"isRegularFile", (LinkOption[])new LinkOption[0]);
    }

    @Test
    public void getLastModifiedTime() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Object)Files.getLastModifiedTime((Path)path, (LinkOption[])new LinkOption[0])).isNotNull();
    }

    @Test(expected=NoSuchFileException.class)
    public void getLastModifiedTimeNoSuchFileException() throws java.io.IOException {
        Path path = Paths.get((String)"/path/to/file", (String[])new String[0]);
        Files.getLastModifiedTime((Path)path, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLastModifiedTimeNull() throws java.io.IOException {
        Files.getLastModifiedTime(null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=NotImplementedException.class)
    public void setLastModifiedTime() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.setLastModifiedTime((Path)path, null);
    }

    @Test(expected=NoSuchFileException.class)
    public void setLastModifiedTimeNoSuchFileException() throws java.io.IOException {
        Path path = Paths.get((String)"/path/to/file", (String[])new String[0]);
        Files.setLastModifiedTime((Path)path, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setLastModifiedTimeNull() throws java.io.IOException {
        Files.setLastModifiedTime(null, null);
    }

    @Test(expected=NotImplementedException.class)
    public void setLastModifiedTimeNull2() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.setLastModifiedTime((Path)path, null);
    }

    @Test
    public void size() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((LongAssert)Assertions.assertThat((long)Files.size((Path)path)).isNotNull()).isEqualTo(0L);
        Path sourceFile = this.newTempDir().resolve("file.txt");
        OutputStream stream = Files.newOutputStream((Path)sourceFile, (OpenOption[])new OpenOption[0]);
        stream.write(97);
        stream.close();
        ((LongAssert)Assertions.assertThat((long)Files.size((Path)sourceFile)).isNotNull()).isEqualTo(1L);
    }

    @Test(expected=NoSuchFileException.class)
    public void sizeNoSuchFileException() throws java.io.IOException {
        Path path = Paths.get((String)"/path/to/file", (String[])new String[0]);
        Files.size((Path)path);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sizeNull() throws java.io.IOException {
        Files.size(null);
    }

    @Test
    public void exists() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.exists((Path)path, (LinkOption[])new LinkOption[0])).isTrue();
        Assertions.assertThat((boolean)Files.exists((Path)this.newTempDir(), (LinkOption[])new LinkOption[0])).isTrue();
        Assertions.assertThat((boolean)Files.exists((Path)Paths.get((String)"/some/path/here", (String[])new String[0]), (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void existsNull() throws java.io.IOException {
        Files.exists(null, (LinkOption[])new LinkOption[0]);
    }

    @Test
    public void notExists() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.notExists((Path)path, (LinkOption[])new LinkOption[0])).isFalse();
        Assertions.assertThat((boolean)Files.notExists((Path)this.newTempDir(), (LinkOption[])new LinkOption[0])).isFalse();
        Assertions.assertThat((boolean)Files.notExists((Path)Paths.get((String)"/some/path/here", (String[])new String[0]), (LinkOption[])new LinkOption[0])).isTrue();
        Assertions.assertThat((boolean)Files.notExists((Path)this.newTempDir().resolve("some.text"), (LinkOption[])new LinkOption[0])).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void notExistsNull() throws java.io.IOException {
        Files.notExists(null, (LinkOption[])new LinkOption[0]);
    }

    @Test
    public void isSameFile() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isSameFile((Path)path, (Path)Paths.get((String)path.toString(), (String[])new String[0]))).isTrue();
        Assertions.assertThat((boolean)Files.isSameFile((Path)path, (Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]))).isFalse();
        Assertions.assertThat((boolean)Files.isSameFile((Path)this.newTempDir(), (Path)this.newTempDir())).isFalse();
        Path dir = this.newTempDir();
        Assertions.assertThat((boolean)Files.isSameFile((Path)dir, (Path)Paths.get((String)dir.toString(), (String[])new String[0]))).isTrue();
        Assertions.assertThat((boolean)Files.isSameFile((Path)Paths.get((String)"/path/to/some/place", (String[])new String[0]), (Path)Paths.get((String)"/path/to/some/place", (String[])new String[0]))).isTrue();
        Assertions.assertThat((boolean)Files.isSameFile((Path)Paths.get((String)"/path/to/some/place", (String[])new String[0]), (Path)Paths.get((String)"/path/to/some/place/a", (String[])new String[0]))).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void isSameFileNull1() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.isSameFile((Path)path, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void isSameFileNull2() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.isSameFile(null, (Path)path);
    }

    @Test(expected=IllegalArgumentException.class)
    public void isSameFileNull3() throws java.io.IOException {
        Files.isSameFile(null, null);
    }

    @Test
    public void isHidden() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isHidden((Path)path)).isFalse();
        Assertions.assertThat((boolean)Files.isHidden((Path)this.newTempDir())).isFalse();
        Assertions.assertThat((boolean)Files.isHidden((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void isHiddenNull() throws java.io.IOException {
        Files.isHidden(null);
    }

    @Test
    public void isReadable() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isReadable((Path)path)).isTrue();
        Assertions.assertThat((boolean)Files.isReadable((Path)this.newTempDir())).isTrue();
        Assertions.assertThat((boolean)Files.isReadable((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void isReadableNull() throws java.io.IOException {
        Files.isReadable(null);
    }

    @Test
    public void isWritable() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isWritable((Path)path)).isTrue();
        Assertions.assertThat((boolean)Files.isWritable((Path)this.newTempDir())).isTrue();
        Assertions.assertThat((boolean)Files.isWritable((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void isWritableNull() throws java.io.IOException {
        Files.isWritable(null);
    }

    @Test
    public void isExecutable() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isExecutable((Path)path)).isFalse();
        Assertions.assertThat((boolean)Files.isExecutable((Path)this.newTempDir())).isTrue();
        Assertions.assertThat((boolean)Files.isExecutable((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void isExecutableNull() throws java.io.IOException {
        Files.isExecutable(null);
    }

    @Test
    public void isSymbolicLink() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isSymbolicLink((Path)path)).isFalse();
        Assertions.assertThat((boolean)Files.isSymbolicLink((Path)this.newTempDir())).isFalse();
        Assertions.assertThat((boolean)Files.isSymbolicLink((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void isSymbolicLinkNull() throws java.io.IOException {
        Files.isSymbolicLink(null);
    }

    @Test
    public void isDirectory() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])).isFalse();
        Assertions.assertThat((boolean)Files.isDirectory((Path)this.newTempDir(), (LinkOption[])new LinkOption[0])).isTrue();
        Assertions.assertThat((boolean)Files.isDirectory((Path)Paths.get((String)"/some/file", (String[])new String[0]), (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void isDirectoryNull() throws java.io.IOException {
        Files.isSymbolicLink(null);
    }

    @Test
    public void isRegularFile() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])).isTrue();
        Assertions.assertThat((boolean)Files.isRegularFile((Path)this.newTempDir(), (LinkOption[])new LinkOption[0])).isFalse();
        Assertions.assertThat((boolean)Files.isRegularFile((Path)Paths.get((String)"/some/file", (String[])new String[0]), (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void isRegularFileNull() throws java.io.IOException {
        Files.isRegularFile(null, (LinkOption[])new LinkOption[0]);
    }

    private static interface MyAttrs
    extends BasicFileAttributes {
    }

    private static interface MyAttrsView
    extends BasicFileAttributeView {
    }
}

