/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ListAssert;
import org.fest.assertions.api.StringAssert;
import org.fest.assertions.data.Index;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.AbstractBaseTest;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.Paths;
import org.kie.commons.java.nio.file.StandardCopyOption;
import org.kie.commons.java.nio.file.attribute.FileAttribute;

public class FileUtilityMethodsTest
extends AbstractBaseTest {
    @Test
    public void newBufferedReader() throws java.io.IOException {
        Path dir = this.newTempDir();
        OutputStream out = Files.newOutputStream((Path)dir.resolve("file.txt"), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)out).isNotNull();
        out.write("content".getBytes());
        out.close();
        BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("file.txt"), (Charset)Charset.defaultCharset());
        Assertions.assertThat((Object)reader).isNotNull();
        ((StringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo((Object)"content");
        Assertions.assertThat((String)reader.readLine()).isNull();
        reader.close();
        try {
            reader.read();
            Assertions.fail((String)"can't read closed stream");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchFileException.class)
    public void newBufferedReaderNoSuchFileException() throws java.io.IOException {
        Files.newBufferedReader((Path)Paths.get((String)"/some/file/here", (String[])new String[0]), (Charset)Charset.defaultCharset());
    }

    @Test(expected=NoSuchFileException.class)
    public void newBufferedReaderNoSuchFileException2() throws java.io.IOException {
        Files.newBufferedReader((Path)this.newTempDir(), (Charset)Charset.defaultCharset());
    }

    @Test(expected=IllegalArgumentException.class)
    public void newBufferedReaderNull1() throws java.io.IOException {
        Files.newBufferedReader(null, (Charset)Charset.defaultCharset());
    }

    @Test(expected=IllegalArgumentException.class)
    public void newBufferedReaderNull2() throws java.io.IOException {
        Files.newBufferedReader((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newBufferedReaderNull3() throws java.io.IOException {
        Files.newBufferedReader(null, null);
    }

    @Test
    public void newBufferedWriter() throws java.io.IOException {
        Path dir = this.newTempDir();
        BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer).isNotNull();
        writer.write("content");
        writer.close();
        BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset());
        Assertions.assertThat((Object)reader).isNotNull();
        ((StringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo((Object)"content");
        Assertions.assertThat((String)reader.readLine()).isNull();
        reader.close();
        Files.newBufferedWriter((Path)Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newBufferedWriterNull1() throws java.io.IOException {
        Files.newBufferedWriter(null, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newBufferedWriterNull2() throws java.io.IOException {
        Files.newBufferedWriter((Path)this.newTempDir().resolve("some"), null, (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newBufferedWriterNull3() throws java.io.IOException {
        Files.newBufferedWriter(null, null, (OpenOption[])new OpenOption[0]);
    }

    @Test
    public void copyIn2Path() throws java.io.IOException {
        Path dir = this.newTempDir();
        BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer).isNotNull();
        writer.write("content");
        writer.close();
        Files.copy((InputStream)Files.newInputStream((Path)dir.resolve("myfile.txt"), (OpenOption[])new OpenOption[0]), (Path)dir.resolve("my_new_file.txt"), (CopyOption[])new CopyOption[0]);
        BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset());
        Assertions.assertThat((Object)reader).isNotNull();
        ((StringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo((Object)"content");
        Assertions.assertThat((String)reader.readLine()).isNull();
        reader.close();
    }

    @Test
    public void copyIn2PathReplaceExisting() throws java.io.IOException {
        Path dir = this.newTempDir();
        BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer).isNotNull();
        writer.write("content");
        writer.close();
        BufferedWriter writer2 = Files.newBufferedWriter((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer2).isNotNull();
        writer2.write("empty_content");
        writer2.close();
        Files.copy((InputStream)Files.newInputStream((Path)dir.resolve("myfile.txt"), (OpenOption[])new OpenOption[0]), (Path)dir.resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset());
        Assertions.assertThat((Object)reader).isNotNull();
        ((StringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo((Object)"content");
        Assertions.assertThat((String)reader.readLine()).isNull();
        reader.close();
    }

    @Test
    public void copyIn2PathReplaceExistingNotExists() throws java.io.IOException {
        Path dir = this.newTempDir();
        BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer).isNotNull();
        writer.write("content");
        writer.close();
        Files.copy((InputStream)Files.newInputStream((Path)dir.resolve("myfile.txt"), (OpenOption[])new OpenOption[0]), (Path)dir.resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset());
        Assertions.assertThat((Object)reader).isNotNull();
        ((StringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo((Object)"content");
        Assertions.assertThat((String)reader.readLine()).isNull();
        reader.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyIn2PathNull1() throws java.io.IOException {
        Files.copy((InputStream)null, (Path)this.newTempDir().resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyIn2PathNull2() throws java.io.IOException {
        Files.copy((InputStream)Files.newInputStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0]), null, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyIn2PathNull3() throws java.io.IOException {
        Files.copy((InputStream)Files.newInputStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0]), (Path)this.newTempDir().resolve("my_new_file.txt"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyIn2PathNull4() throws java.io.IOException {
        Files.copy((InputStream)Files.newInputStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0]), (Path)this.newTempDir().resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{null});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void copyIn2PathInvalidOption() throws java.io.IOException {
        Files.copy((InputStream)Files.newInputStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0]), (Path)this.newTempDir().resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{LinkOption.NOFOLLOW_LINKS});
    }

    @Test
    public void copyPath2Out() throws java.io.IOException {
        Path dir = this.newTempDir();
        BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer).isNotNull();
        writer.write("content");
        writer.close();
        Files.copy((Path)dir.resolve("myfile.txt"), (OutputStream)Files.newOutputStream((Path)dir.resolve("my_new_file.txt"), (OpenOption[])new OpenOption[0]));
        BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset());
        Assertions.assertThat((Object)reader).isNotNull();
        ((StringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo((Object)"content");
        Assertions.assertThat((String)reader.readLine()).isNull();
        reader.close();
    }

    @Test(expected=NoSuchFileException.class)
    public void copyPath2OutNotExists() throws java.io.IOException {
        Files.copy((Path)this.newTempDir().resolve("myfile.txt"), (OutputStream)Files.newOutputStream((Path)this.newTempDir().resolve("my_new_file.txt"), (OpenOption[])new OpenOption[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyPath2OutNull1() throws java.io.IOException {
        Files.copy(null, (OutputStream)Files.newOutputStream((Path)this.newTempDir().resolve("my_new_file.txt"), (OpenOption[])new OpenOption[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyPath2OutNull2() throws java.io.IOException {
        Files.copy((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyPath2OutInvalidOption() throws java.io.IOException {
        Files.copy(null, null);
    }

    @Test
    public void readAllBytes() throws java.io.IOException {
        Path dir = this.newTempDir();
        BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer).isNotNull();
        writer.write("content");
        writer.close();
        byte[] result = Files.readAllBytes((Path)dir.resolve("myfile.txt"));
        Assertions.assertThat((byte[])result).isNotEmpty().hasSize("content".getBytes().length).isEqualTo((Object)"content".getBytes());
    }

    @Test(expected=OutOfMemoryError.class)
    @Ignore
    public void readAllBytesOutOfMemory() throws java.io.IOException {
        Path file = this.newTempDir().resolve("file.big");
        RandomAccessFile f = new RandomAccessFile(file.toFile(), "rw");
        f.setLength(0x80000000L);
        f.close();
        Files.readAllBytes((Path)file);
    }

    @Test(expected=NoSuchFileException.class)
    public void readAllBytesFileNotExists() throws java.io.IOException {
        Files.readAllBytes((Path)this.newTempDir().resolve("file.big"));
    }

    @Test(expected=NoSuchFileException.class)
    public void readAllBytesDir() throws java.io.IOException {
        Files.readAllBytes((Path)this.newTempDir());
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAllBytesNull() throws java.io.IOException {
        Files.readAllBytes(null);
    }

    @Test
    public void readAllLines() throws java.io.IOException {
        Path dir = this.newTempDir();
        BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer).isNotNull();
        writer.write("content");
        writer.close();
        List result = Files.readAllLines((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset());
        ((ListAssert)((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).hasSize(1)).contains((Object)"content", Index.atIndex((int)0));
        BufferedWriter writer2 = Files.newBufferedWriter((Path)dir.resolve("myfile2.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer2).isNotNull();
        writer2.write("content\nnewFile\nline");
        writer2.close();
        List result2 = Files.readAllLines((Path)dir.resolve("myfile2.txt"), (Charset)Charset.defaultCharset());
        ((ListAssert)((ListAssert)Assertions.assertThat((List)result2).isNotEmpty()).hasSize(3)).contains((Object)"content", Index.atIndex((int)0)).contains((Object)"newFile", Index.atIndex((int)1)).contains((Object)"line", Index.atIndex((int)2));
    }

    @Test(expected=NoSuchFileException.class)
    public void readAllLinesFileNotExists() throws java.io.IOException {
        Files.readAllLines((Path)this.newTempDir().resolve("file.big"), (Charset)Charset.defaultCharset());
    }

    @Test(expected=NoSuchFileException.class)
    public void readAllLinesDir() throws java.io.IOException {
        Files.readAllLines((Path)this.newTempDir(), (Charset)Charset.defaultCharset());
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAllLinesNull1() throws java.io.IOException {
        Files.readAllLines(null, (Charset)Charset.defaultCharset());
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAllLinesNull2() throws java.io.IOException {
        Files.readAllLines((Path)Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAllLinesNull3() throws java.io.IOException {
        Files.readAllLines(null, null);
    }

    @Test
    public void write() {
        Path dir = this.newTempDir();
        Files.write((Path)dir.resolve("file.txt"), (byte[])"content".getBytes(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes((Path)dir.resolve("file.txt"))).hasSize("content".getBytes().length).isEqualTo((Object)"content".getBytes());
    }

    @Test(expected=IOException.class)
    public void writeDir() {
        Files.write((Path)this.newTempDir(), (byte[])"content".getBytes(), (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeNull1() {
        Files.write((Path)this.newTempDir().resolve("file.txt"), null, (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeNull2() {
        Files.write(null, (byte[])"".getBytes(), (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeNull3() {
        Files.write(null, null, (OpenOption[])new OpenOption[0]);
    }

    @Test
    public void writeLines() {
        Path dir = this.newTempDir();
        ArrayList<String> content = new ArrayList<String>(){
            {
                this.add("some");
                this.add("value");
            }
        };
        Files.write((Path)dir.resolve("file.txt"), (Iterable)content, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        List result = Files.readAllLines((Path)dir.resolve("file.txt"), (Charset)Charset.defaultCharset());
        ((ListAssert)((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).hasSize(2)).contains((Object)"some", Index.atIndex((int)0)).contains((Object)"value", Index.atIndex((int)1));
    }

    @Test(expected=IOException.class)
    public void writeLinesDir() {
        ArrayList<String> content = new ArrayList<String>(){
            {
                this.add("some");
                this.add("value");
            }
        };
        Files.write((Path)this.newTempDir(), (Iterable)content, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeLinesNull1() {
        Files.write((Path)this.newTempDir().resolve("file.txt"), null, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeLinesNull2() {
        ArrayList content = new ArrayList();
        Files.write(null, content, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeLinesNull4() {
        ArrayList content = new ArrayList();
        Files.write((Path)this.newTempDir().resolve("file.txt"), content, null, (OpenOption[])new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeLinesNull5() {
        ArrayList content = new ArrayList();
        Files.write(null, null, null);
    }
}

