/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.util.FileUtils;
import org.fest.assertions.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.commons.java.nio.fs.jgit.JGitFileSystemProvider;

public class NewProviderDefineDirTest {
    protected static final Map<String, Object> EMPTY_ENV = Collections.emptyMap();
    private static final List<File> tempFiles = new ArrayList<File>();

    protected static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            try {
                FileUtils.delete((File)tempFile, (int)1);
            }
            catch (IOException iOException) {}
        }
    }

    @Test
    public void testUsingProvidedPath() throws IOException {
        File dir = NewProviderDefineDirTest.createTempDirectory();
        System.setProperty("org.kie.nio.git.dir", dir.toString());
        JGitFileSystemProvider.loadConfig();
        JGitFileSystemProvider provider = new JGitFileSystemProvider();
        URI newRepo = URI.create("git://repo-name");
        provider.newFileSystem(newRepo, EMPTY_ENV);
        Object[] names = dir.list();
        Assertions.assertThat((Object[])names).isNotEmpty().contains(new Object[]{".niogit"});
        Object[] repos = new File(dir, ".niogit").list();
        Assertions.assertThat((Object[])repos).isNotEmpty().contains(new Object[]{"repo-name.git"});
        System.setProperty("org.kie.nio.git.dir", "");
    }
}

