/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.jgit;

import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.fest.assertions.api.StringAssert;
import org.junit.Before;
import org.junit.Test;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.spi.FileSystemProvider;
import org.kie.commons.java.nio.fs.jgit.JGitFileSystem;
import org.kie.commons.java.nio.fs.jgit.JGitPathImpl;
import org.mockito.Mockito;

public class JGitPathTest {
    final FileSystemProvider fsp = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
    final JGitFileSystem fs = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)this.fsp);
        Mockito.when((Object)this.fsp.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)this.fsp.getScheme()).thenReturn((Object)"git");
    }

    @Test
    public void testSimpleBranchedGit() {
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"", (String)"master@my-host", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://master@my-host/");
        Assertions.assertThat((Iterable)path.getRoot()).isEqualTo((Object)path);
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(0);
        ((IterableAssert)Assertions.assertThat((Iterable)path.getRoot()).isNotNull()).isEqualTo((Object)path);
    }

    @Test
    public void testSimpleBranchedGitRoot() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/", (String)"master@my-host", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://master@my-host/");
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(0);
    }

    @Test
    public void testSimpleBranchedGitRelative() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"home", (String)"master@my-host", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"home");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://master@my-host/:home");
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(1);
    }

    @Test
    public void testSimpleBranchedGitRoot2() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to/some/place.txt", (String)"master@my-host", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://master@my-host/path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"path");
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"/");
    }

    @Test
    public void testSimpleBranchedGitRoot2Spaced() throws URIException {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)URIUtil.decode((String)"/path/to/some/some%20place.txt"), (String)"master@my-host", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/some/some place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://master@my-host/path/to/some/some%20place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"path");
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"/");
    }

    @Test
    public void testSimpleImplicitBranchGit() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to/some/place.txt", (String)"my-host", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://master@my-host/path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"path");
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"/");
    }

    @Test
    public void testSimpleImplicitBranchGitRoot() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/", (String)"my-host", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://master@my-host/");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(0);
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"/");
        try {
            ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"");
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRelativize() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to/some/place", (String)"master@my-host", (boolean)false);
        Path relative = path.relativize((Path)other);
        Assertions.assertThat((Iterable)relative).isNotNull();
        Assertions.assertThat((String)relative.toString()).isEqualTo((Object)"some/place");
        JGitPathImpl path2 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to/some/place", (String)"master@my-host", (boolean)false);
        JGitPathImpl other2 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        Path relative2 = path2.relativize((Path)other2);
        Assertions.assertThat((Iterable)relative2).isNotNull();
        Assertions.assertThat((String)relative2.toString()).isEqualTo((Object)"../..");
        JGitPathImpl path3 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other3 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        Path relative3 = path3.relativize((Path)other3);
        Assertions.assertThat((Iterable)relative3).isNotNull();
        Assertions.assertThat((String)relative3.toString()).isEqualTo((Object)"");
        JGitPathImpl path4 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other4 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to/some/place", (String)"master@my-host", (boolean)false);
        Path relative4 = path4.relativize((Path)other4);
        Assertions.assertThat((Iterable)relative4).isNotNull();
        Assertions.assertThat((String)relative4.toString()).isEqualTo((Object)"some/place");
        JGitPathImpl path5 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other5 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"some/place", (String)"master@my-host", (boolean)false);
        Path relative5 = path5.relativize((Path)other5);
        Assertions.assertThat((Iterable)relative5).isNotNull();
        Assertions.assertThat((String)relative5.toString()).isEqualTo((Object)"../../some/place");
        JGitPathImpl path6 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"some/place", (String)"master@my-host", (boolean)false);
        JGitPathImpl other6 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        Path relative6 = path6.relativize((Path)other6);
        Assertions.assertThat((Iterable)relative6).isNotNull();
        Assertions.assertThat((String)relative6.toString()).isEqualTo((Object)"../../path/to");
        JGitPathImpl path7 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to/some/thing/here", (String)"master@my-host", (boolean)false);
        JGitPathImpl other7 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"some/place", (String)"master@my-host", (boolean)false);
        Path relative7 = path7.relativize((Path)other7);
        Assertions.assertThat((Iterable)relative7).isNotNull();
        Assertions.assertThat((String)relative7.toString()).isEqualTo((Object)"../../../../../some/place");
        JGitPathImpl path8 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"some/place", (String)"master@my-host", (boolean)false);
        JGitPathImpl other8 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to/some/thing/here", (String)"master@my-host", (boolean)false);
        Path relative8 = path8.relativize((Path)other8);
        Assertions.assertThat((Iterable)relative8).isNotNull();
        Assertions.assertThat((String)relative8.toString()).isEqualTo((Object)"../../path/to/some/thing/here");
        JGitPathImpl path9 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other9 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        Path relative9 = path9.relativize((Path)other9);
        Assertions.assertThat((Iterable)relative9).isNotNull();
        Assertions.assertThat((String)relative9.toString()).isEqualTo((Object)"");
        JGitPathImpl path10 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other10 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        Path relative10 = path10.relativize((Path)other10);
        Assertions.assertThat((Iterable)relative10).isNotNull();
        Assertions.assertThat((String)relative10.toString()).isEqualTo((Object)"");
    }
}

