/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.fest.assertions.api.StringAssert;
import org.junit.Test;
import org.kie.commons.java.nio.file.FileStore;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.spi.FileSystemProvider;
import org.kie.commons.java.nio.fs.jgit.AbstractTestInfra;
import org.kie.commons.java.nio.fs.jgit.JGitFileSystem;
import org.mockito.Mockito;

public class JGitFileSystemTest
extends AbstractTestInfra {
    @Test
    public void testOnlyLocalRoot() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo((Object)"/");
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo((Object)"my-repo");
        Assertions.assertThat((Iterable)fileSystem.getRootDirectories()).hasSize(1);
        Path root = (Path)fileSystem.getRootDirectories().iterator().next();
        Assertions.assertThat((String)root.toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)root.getRoot().toString()).isEqualTo((Object)"/");
    }

    @Test
    public void testRemoteRoot() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        File tempDir = JGitFileSystemTest.createTempDirectory();
        Git git = Git.cloneRepository().setNoCheckout(false).setBare(true).setCloneAllBranches(true).setURI(this.setupGit().getRepository().getDirectory().toString()).setDirectory(tempDir).call();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo((Object)"/");
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo((Object)"my-repo");
        Assertions.assertThat((Iterable)fileSystem.getRootDirectories()).hasSize(1);
        Path root = (Path)fileSystem.getRootDirectories().iterator().next();
        Assertions.assertThat((String)root.toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)root.getRoot().toString()).isEqualTo((Object)"/");
    }

    @Test
    public void testProvider() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo((Object)"my-repo");
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo((Object)"/");
        Assertions.assertThat((Object)fileSystem.provider()).isEqualTo((Object)fsProvider);
    }

    @Test(expected=IllegalStateException.class)
    public void testClose() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo((Object)"/");
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo((Object)"my-repo");
        Assertions.assertThat((boolean)fileSystem.isOpen()).isTrue();
        Assertions.assertThat((Iterable)fileSystem.getFileStores()).isNotNull();
        fileSystem.close();
        Assertions.assertThat((boolean)fileSystem.isOpen()).isFalse();
        Assertions.assertThat((Iterable)fileSystem.getFileStores()).isNotNull();
    }

    @Test
    public void testSupportedFileAttributeViews() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo((Object)"/");
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo((Object)"my-repo");
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)fileSystem.supportedFileAttributeViews()).isNotEmpty()).hasSize(2)).contains((Object[])new String[]{"basic", "version"});
    }

    @Test
    public void testPathNonBranchRooted() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Path path = fileSystem.getPath("/path/to/some/place.txt", new String[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://master@my-repo/path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"path");
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"/");
    }

    @Test
    public void testPathNonBranchNonRooted() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Path path = fileSystem.getPath("path/to/some/place.txt", new String[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://master@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"path");
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"");
    }

    @Test
    public void testPathBranchRooted() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Path path = fileSystem.getPath("test-branch", new String[]{"/path/to/some/place.txt"});
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://test-branch@my-repo/path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"path");
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"/");
    }

    @Test
    public void testPathBranchNonRooted() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Path path = fileSystem.getPath("test-branch", new String[]{"path/to/some/place.txt"});
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://test-branch@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"path");
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"");
    }

    @Test
    public void testPathBranchRooted2() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Path path = fileSystem.getPath("test-branch", new String[]{"/path/to", "some/place.txt"});
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://test-branch@my-repo/path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"path");
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"/");
    }

    @Test
    public void testPathBranchNonRooted2() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Path path = fileSystem.getPath("test-branch", new String[]{"path/to", "some/place.txt"});
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo((Object)"git://test-branch@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((StringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo((Object)"path");
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"");
    }

    @Test
    public void testFileStore() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        File tempDir = JGitFileSystemTest.createTempDirectory();
        Git git = this.setupGit(tempDir);
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        Assertions.assertThat((Iterable)fileSystem.getFileStores()).hasSize(1);
        FileStore fileStore = (FileStore)fileSystem.getFileStores().iterator().next();
        Assertions.assertThat((Object)fileStore).isNotNull();
        Assertions.assertThat((long)fileStore.getTotalSpace()).isEqualTo(tempDir.getTotalSpace());
        Assertions.assertThat((long)fileStore.getUsableSpace()).isEqualTo(tempDir.getUsableSpace());
    }

    @Test
    public void testPathEqualsWithDifferentRepos() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Git git1 = this.setupGit();
        JGitFileSystem fileSystem1 = new JGitFileSystem(fsProvider, git1, "my-repo1", CredentialsProvider.getDefault());
        Git git2 = this.setupGit();
        JGitFileSystem fileSystem2 = new JGitFileSystem(fsProvider, git2, "my-repo2", CredentialsProvider.getDefault());
        Path path1 = fileSystem1.getPath("master", new String[]{"/path/to/some.txt"});
        Path path2 = fileSystem2.getPath("master", new String[]{"/path/to/some.txt"});
        Assertions.assertThat((Iterable)path1).isNotEqualTo((Object)path2);
        Assertions.assertThat((Iterable)path1).isEqualTo((Object)fileSystem1.getPath("/path/to/some.txt", new String[0]));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNewWatchService() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        fileSystem.newWatchService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetUserPrincipalLookupService() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        fileSystem.getUserPrincipalLookupService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetPathMatcher() throws IOException, GitAPIException {
        FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystem fileSystem = new JGitFileSystem(fsProvider, git, "my-repo", CredentialsProvider.getDefault());
        fileSystem.getPathMatcher("*");
    }

    static {
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("guest", ""));
    }
}

