/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.io;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.commons.io.CommonIOExceptionsServiceDotFileTest;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.kieora.backend.lucene.FieldFactory;
import org.kie.kieora.backend.lucene.LuceneIndexEngine;
import org.kie.kieora.backend.lucene.LuceneSetup;
import org.kie.kieora.backend.lucene.fields.SimpleFieldFactory;
import org.kie.kieora.backend.lucene.metamodels.InMemoryMetaModelStore;
import org.kie.kieora.backend.lucene.setups.BaseLuceneSetup;
import org.kie.kieora.backend.lucene.setups.RAMLuceneSetup;
import org.kie.kieora.engine.MetaIndexEngine;
import org.kie.kieora.engine.MetaModelStore;
import org.kie.kieora.io.IOServiceIndexedImpl;

public class IOServiceIndexedGitImplTest
extends CommonIOExceptionsServiceDotFileTest {
    protected IOService ioService = null;
    private MetaModelStore metaModelStore;
    private BaseLuceneSetup luceneSetup;
    private static boolean created = false;

    public IOService ioService() {
        if (this.ioService == null) {
            this.metaModelStore = new InMemoryMetaModelStore();
            this.luceneSetup = new RAMLuceneSetup();
            this.ioService = new IOServiceIndexedImpl((MetaIndexEngine)new LuceneIndexEngine(this.metaModelStore, (LuceneSetup)this.luceneSetup, (FieldFactory)new SimpleFieldFactory()));
        }
        return this.ioService;
    }

    protected int testFileAttrSize4() {
        return 7;
    }

    protected int testFileAttrSize3() {
        return 10;
    }

    protected int testFileAttrSize2() {
        return 11;
    }

    protected int testFileAttrSize1() {
        return 10;
    }

    protected int testDirectoryAttrSize4() {
        return 7;
    }

    protected int testDirectoryAttrSize3() {
        return 10;
    }

    protected int testDirectoryAttrSize2() {
        return 11;
    }

    protected int testDirectoryAttrSize1() {
        return 10;
    }

    protected int createDirectoriesAttrSize() {
        return 8;
    }

    protected int testNewByteChannelAttrSize() {
        return 8;
    }

    @Test
    public void testIndexedFile() throws IOException {
        Path path = this.getDirectoryPath().resolveSibling("someNewOtherPath").resolve("myIndexedFile.txt");
        this.ioService().write(path, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return IOServiceIndexedGitImplTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "x_hello";
            }

            public String value() {
                return "hello some world jhere";
            }
        }, new FileAttribute<Integer>(){

            public String name() {
                return "int";
            }

            public Integer value() {
                return 10;
            }
        }});
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()));
        Assert.assertEquals((long)3L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperties().size());
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("int"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("x_hello"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom"));
        this.ioService().setAttribute(path, "my_new_key", (Object)"some big value here to be able to query for");
        Assert.assertEquals((long)4L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperties().size());
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("int"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("x_hello"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("my_new_key"));
        Assert.assertEquals((long)1L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("int").getTypes().size());
        Assert.assertEquals((long)1L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("x_hello").getTypes().size());
        Assert.assertEquals((long)1L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().size());
        Assert.assertEquals((long)1L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("my_new_key").getTypes().size());
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("int").getTypes().contains(Integer.class));
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("x_hello").getTypes().contains(String.class));
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().contains(Date.class));
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("my_new_key").getTypes().contains(String.class));
        this.ioService().write(path.resolveSibling("otherIndexedFile.txt"), "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Long value() {
                return 10L;
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "my_new_key";
            }

            public String value() {
                return "some other content here that only this can be found.";
            }
        }});
        Assert.assertEquals((long)2L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().size());
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().contains(Date.class));
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().contains(Long.class));
        IndexSearcher searcher = this.luceneSetup.nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("my_new_key", "found")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("my_new_key", "query")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("my_new_key", "some")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        this.luceneSetup.nrtRelease(searcher);
    }

    public Path getFilePath() {
        Path file = this.ioService().get(URI.create("git://indexed-repo-test/_myfile" + new Random(10L).nextInt() + ".txt"));
        this.ioService().deleteIfExists(file);
        return file;
    }

    public Path getTargetPath() {
        Path file = this.ioService().get(URI.create("git://indexed-repo-test/_myTargetFile" + new Random(10L).nextInt() + ".txt"));
        this.ioService().deleteIfExists(file);
        return file;
    }

    public Path getDirectoryPath() {
        Path dir = this.ioService().get(URI.create("git://indexed-repo-test/_someDir" + new Random(10L).nextInt()));
        this.ioService().deleteIfExists(dir);
        return dir;
    }

    public Path getComposedDirectoryPath() {
        return this.ioService().get(URI.create("git://indexed-repo-test/path/to/_someNewRandom" + new Random(10L).nextInt()));
    }

    private Path getRootPath() {
        return this.ioService().get(URI.create("git://indexed-repo-test/"));
    }

    @Test
    public void testRoot() throws IOException {
        Path path = this.getRootPath();
        this.ioService().setAttributes(path, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "my_new_key";
            }

            public Object value() {
                return "value";
            }
        }});
        Map attrsValue = this.ioService().readAttributes(path);
        Assert.assertEquals((long)7L, (long)attrsValue.size());
        Assert.assertTrue((boolean)attrsValue.containsKey("my_new_key"));
        this.ioService().setAttributes(path, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "my_new_key";
            }

            public Object value() {
                return null;
            }
        }});
        Map attrsValue2 = this.ioService().readAttributes(path);
        Assert.assertEquals((long)6L, (long)attrsValue2.size());
        Assert.assertFalse((boolean)attrsValue2.containsKey("my_new_key"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws IOException {
        if (!created) {
            String path = IOServiceIndexedGitImplTest.createTempDirectory().getAbsolutePath();
            System.setProperty("org.kie.nio.git.dir", path);
            System.out.println(".niogit: " + path);
            URI newRepo = URI.create("git://indexed-repo-test");
            try {
                this.ioService().newFileSystem(newRepo, new HashMap());
            }
            catch (Exception exception) {
            }
            finally {
                created = true;
            }
        }
    }
}

