/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.commons.io.IOService;
import org.kie.commons.io.attribute.DublinCoreView;
import org.kie.commons.java.nio.base.version.VersionAttributeView;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.kieora.backend.lucene.FieldFactory;
import org.kie.kieora.backend.lucene.LuceneIndexEngine;
import org.kie.kieora.backend.lucene.LuceneSetup;
import org.kie.kieora.backend.lucene.fields.SimpleFieldFactory;
import org.kie.kieora.backend.lucene.metamodels.InMemoryMetaModelStore;
import org.kie.kieora.backend.lucene.setups.BaseLuceneSetup;
import org.kie.kieora.backend.lucene.setups.RAMLuceneSetup;
import org.kie.kieora.engine.MetaIndexEngine;
import org.kie.kieora.engine.MetaModelStore;
import org.kie.kieora.io.BatchIndex;
import org.kie.kieora.io.IOServiceIndexedImpl;

public class BatchIndexTest {
    private static IOService ioService = null;
    private static MetaModelStore metaModelStore;
    private static BaseLuceneSetup luceneSetup;
    private static MetaIndexEngine indexEngine;

    public static IOService ioService() {
        if (ioService == null) {
            metaModelStore = new InMemoryMetaModelStore();
            luceneSetup = new RAMLuceneSetup();
            indexEngine = new LuceneIndexEngine(metaModelStore, (LuceneSetup)luceneSetup, (FieldFactory)new SimpleFieldFactory());
            ioService = new IOServiceIndexedImpl(indexEngine, new Class[]{DublinCoreView.class, VersionAttributeView.class});
        }
        return ioService;
    }

    @BeforeClass
    public static void setup() throws IOException {
        String path = BatchIndexTest.createTempDirectory().getAbsolutePath();
        System.setProperty("org.kie.nio.git.dir", path);
        System.out.println(".niogit: " + path);
        URI newRepo = URI.create("git://temp-repo-test");
        try {
            BatchIndexTest.ioService().newFileSystem(newRepo, new HashMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIndex() throws IOException {
        Path file = BatchIndexTest.ioService().get("git://temp-repo-test/path/to/file.txt", new String[0]);
        BatchIndexTest.ioService().write(file, "some content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My User Name Here";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "initial document version, should be revised later.";
            }
        }});
        file = BatchIndexTest.ioService().get("git://temp-repo-test/path/to/some/complex/file.txt", new String[0]);
        BatchIndexTest.ioService().write(file, "some other content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My Second User Name";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "important document, should be used right now.";
            }
        }});
        file = BatchIndexTest.ioService().get("git://temp-repo-test/simple.doc", new String[0]);
        BatchIndexTest.ioService().write(file, "some doc content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My Original User";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "release document updated, should be checked by boss.";
            }
        }});
        file = BatchIndexTest.ioService().get("git://temp-repo-test/xxx/simple.xls", new String[0]);
        BatchIndexTest.ioService().write(file, "plans!?", new OpenOption[0]);
        new BatchIndex(indexEngine, BatchIndexTest.ioService(), new Class[]{DublinCoreView.class, VersionAttributeView.class}).run(BatchIndexTest.ioService().get("git://temp-repo-test/", new String[0]));
        IndexSearcher searcher = luceneSetup.nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("dcore.author", "name")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("dcore.author", "second")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)4L, (long)hits.length);
        luceneSetup.nrtRelease(searcher);
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

