/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.commons.io.IOService;
import org.kie.commons.io.SimpleFSIOServiceDotFileTest;
import org.kie.commons.io.attribute.DublinCoreView;
import org.kie.commons.java.nio.base.version.VersionAttributeView;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.kieora.backend.lucene.FieldFactory;
import org.kie.kieora.backend.lucene.LuceneIndexEngine;
import org.kie.kieora.backend.lucene.LuceneSetup;
import org.kie.kieora.backend.lucene.fields.SimpleFieldFactory;
import org.kie.kieora.backend.lucene.metamodels.InMemoryMetaModelStore;
import org.kie.kieora.backend.lucene.setups.BaseLuceneSetup;
import org.kie.kieora.backend.lucene.setups.RAMLuceneSetup;
import org.kie.kieora.engine.MetaIndexEngine;
import org.kie.kieora.engine.MetaModelStore;
import org.kie.kieora.io.IOServiceIndexedImpl;

@Ignore
public class IOServiceIndexedFSImplTest
extends SimpleFSIOServiceDotFileTest {
    protected static IOService ioService = null;
    private MetaModelStore metaModelStore;
    private BaseLuceneSetup luceneSetup;

    public IOService ioService() {
        if (ioService == null) {
            this.metaModelStore = new InMemoryMetaModelStore();
            this.luceneSetup = new RAMLuceneSetup();
            ioService = new IOServiceIndexedImpl((MetaIndexEngine)new LuceneIndexEngine(this.metaModelStore, (LuceneSetup)this.luceneSetup, (FieldFactory)new SimpleFieldFactory()), new Class[]{DublinCoreView.class, VersionAttributeView.class});
        }
        return ioService;
    }

    @Test
    public void testIndexedFile() throws IOException {
        Path dir = this.ioService().createDirectories(this.getDirectoryPath().resolveSibling("someNewOtherPath"), new FileAttribute[0]);
        Path path = dir.resolve("myIndexedFile.txt");
        this.ioService().write(path, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return IOServiceIndexedFSImplTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "x_hello";
            }

            public String value() {
                return "hello some world jhere";
            }
        }, new FileAttribute<Integer>(){

            public String name() {
                return "int";
            }

            public Integer value() {
                return 10;
            }
        }});
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()));
        Assert.assertEquals((long)3L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperties().size());
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("int"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("x_hello"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom"));
        this.ioService().setAttribute(path, "my_new_key", (Object)"some big value here to be able to query for");
        Assert.assertEquals((long)4L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperties().size());
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("int"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("x_hello"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom"));
        Assert.assertNotNull((Object)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("my_new_key"));
        Assert.assertEquals((long)1L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("int").getTypes().size());
        Assert.assertEquals((long)1L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("x_hello").getTypes().size());
        Assert.assertEquals((long)1L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().size());
        Assert.assertEquals((long)1L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("my_new_key").getTypes().size());
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("int").getTypes().contains(Integer.class));
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("x_hello").getTypes().contains(String.class));
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().contains(Date.class));
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("my_new_key").getTypes().contains(String.class));
        this.ioService().write(path.resolveSibling("otherIndexedFile.txt"), "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Long value() {
                return 10L;
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "my_new_key";
            }

            public String value() {
                return "some other content here that only this can be found.";
            }
        }});
        Assert.assertEquals((long)2L, (long)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().size());
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().contains(Date.class));
        Assert.assertTrue((boolean)this.metaModelStore.getMetaObject(Path.class.getName()).getProperty("custom").getTypes().contains(Long.class));
        IndexSearcher searcher = this.luceneSetup.nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("my_new_key", "found")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("my_new_key", "query")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("my_new_key", "some")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        this.luceneSetup.nrtRelease(searcher);
    }
}

