/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.io;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kie.commons.io.IOSearchService;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.FileSystemId;
import org.kie.commons.java.nio.base.SegmentedPath;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.kieora.model.KObject;
import org.kie.kieora.search.ClusterSegment;
import org.kie.kieora.search.SearchIndex;

public class IOSearchIndex
implements IOSearchService {
    private final SearchIndex searchIndex;
    private final IOService ioService;

    public IOSearchIndex(SearchIndex searchIndex, IOService ioService) {
        this.searchIndex = (SearchIndex)PortablePreconditions.checkNotNull((String)"searchIndex", (Object)searchIndex);
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
    }

    public List<Path> searchByAttrs(Map<String, ?> attrs, int pageSize, int startIndex, Path ... roots) {
        final List kObjects = this.searchIndex.searchByAttrs(attrs, pageSize, startIndex, this.buildClusterSegments(roots));
        return new ArrayList<Path>(){
            {
                for (KObject kObject : kObjects) {
                    this.add(IOSearchIndex.this.ioService.get(URI.create(kObject.getKey())));
                }
            }
        };
    }

    public List<Path> fullTextSearch(String term, int pageSize, int startIndex, Path ... roots) {
        final List kObjects = this.searchIndex.fullTextSearch(term, pageSize, startIndex, this.buildClusterSegments(roots));
        return new ArrayList<Path>(){
            {
                for (KObject kObject : kObjects) {
                    this.add(IOSearchIndex.this.ioService.get(URI.create(kObject.getKey())));
                }
            }
        };
    }

    public int searchByAttrsHits(Map<String, ?> attrs, Path ... roots) {
        return this.searchIndex.searchByAttrsHits(attrs, this.buildClusterSegments(roots));
    }

    public int fullTextSearchHits(String term, Path ... roots) {
        return this.searchIndex.fullTextSearchHits(term, this.buildClusterSegments(roots));
    }

    private ClusterSegment[] buildClusterSegments(Path[] roots) {
        if (roots == null || roots.length == 0) {
            return new ClusterSegment[0];
        }
        ClusterSegment[] clusterSegments = new ClusterSegment[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            Path root = roots[i];
            final SegmentedPath segmentedPath = (SegmentedPath)root;
            final FileSystemId fsId = (FileSystemId)root.getFileSystem();
            clusterSegments[i] = new ClusterSegment(){

                public String getClusterId() {
                    return fsId.id();
                }

                public String[] segmentIds() {
                    return new String[]{segmentedPath.getSegmentId()};
                }
            };
        }
        return clusterSegments;
    }
}

