/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.commons.data.Pair;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.io.impl.IOServiceDotFileImpl;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.FileSystemId;
import org.kie.commons.java.nio.base.Properties;
import org.kie.commons.java.nio.base.dotfiles.DotFileUtils;
import org.kie.commons.java.nio.channels.SeekableByteChannel;
import org.kie.commons.java.nio.file.AtomicMoveNotSupportedException;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.DirectoryNotEmptyException;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.FileSystemAlreadyExistsException;
import org.kie.commons.java.nio.file.FileSystemNotFoundException;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.ProviderNotFoundException;
import org.kie.commons.java.nio.file.StandardWatchEventKind;
import org.kie.commons.java.nio.file.WatchEvent;
import org.kie.commons.java.nio.file.WatchService;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.commons.java.nio.file.attribute.FileAttributeView;
import org.kie.commons.validation.Preconditions;
import org.kie.kieora.engine.MetaIndexEngine;
import org.kie.kieora.io.BatchIndex;
import org.kie.kieora.io.KObjectUtil;

public class IOServiceIndexedImpl
extends IOServiceDotFileImpl {
    private final MetaIndexEngine indexEngine;
    private final BatchIndex batchIndex;
    private final Class<? extends FileAttributeView>[] views;
    private final Set<FileSystem> indexedFSs = new HashSet<FileSystem>();
    private final ThreadGroup threadGroup = new ThreadGroup("IOServiceIndexing");

    public IOServiceIndexedImpl(MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        this.indexEngine = (MetaIndexEngine)Preconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, views);
        this.views = views;
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, ProviderNotFoundException, SecurityException {
        try {
            FileSystem fs = super.getFileSystem(uri);
            this.indexIfFresh(fs);
            return fs;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemNotFoundException ex) {
            throw ex;
        }
        catch (ProviderNotFoundException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw ex;
        }
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        try {
            FileSystem fs = super.newFileSystem(uri, env);
            this.index(fs);
            this.setupWatchService(fs);
            return fs;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemAlreadyExistsException ex) {
            throw ex;
        }
        catch (ProviderNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw ex;
        }
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env, FileSystemType type) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        try {
            FileSystem fs = super.newFileSystem(uri, env, type);
            this.index(fs);
            this.setupWatchService(fs);
            return fs;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemAlreadyExistsException ex) {
            throw ex;
        }
        catch (ProviderNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw ex;
        }
    }

    private void setupWatchService(FileSystem fs) {
        final WatchService ws = fs.newWatchService();
        new Thread(this.threadGroup, "IOService(WatchService[" + ((FileSystemId)fs).id() + "])"){

            @Override
            public void run() {
                block0: while (true) {
                    List events = ws.take().pollEvents();
                    Iterator i$ = events.iterator();
                    while (true) {
                        Path path;
                        if (!i$.hasNext()) continue block0;
                        WatchEvent object = (WatchEvent)i$.next();
                        if (!(object.kind() != StandardWatchEventKind.ENTRY_MODIFY && object.kind() != StandardWatchEventKind.ENTRY_CREATE || (path = (Path)object.context()).getFileName().toString().startsWith("."))) {
                            for (Class view : IOServiceIndexedImpl.this.views) {
                                IOServiceIndexedImpl.this.getFileAttributeView(path, view);
                            }
                            FileAttribute[] allAttrs = IOServiceIndexedImpl.this.convert(IOServiceIndexedImpl.this.readAttributes(path));
                            IOServiceIndexedImpl.this.indexEngine.index(KObjectUtil.toKObject(path, allAttrs));
                        }
                        if (object.kind() == StandardWatchEventKind.ENTRY_RENAME) {
                            Pair pair = (Pair)object.context();
                            IOServiceIndexedImpl.this.indexEngine.rename(KObjectUtil.toKObjectKey((Path)pair.getK1()), KObjectUtil.toKObjectKey((Path)pair.getK2()));
                        }
                        if (object.kind() != StandardWatchEventKind.ENTRY_DELETE) continue;
                        path = (Path)object.context();
                        IOServiceIndexedImpl.this.indexEngine.delete(KObjectUtil.toKObjectKey(path));
                    }
                    break;
                }
            }
        }.start();
    }

    public synchronized void delete(Path path) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        super.delete(path);
        this.indexEngine.delete(KObjectUtil.toKObjectKey(path));
    }

    public synchronized boolean deleteIfExists(Path path) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException {
        boolean result = super.deleteIfExists(path);
        if (result) {
            this.indexEngine.delete(KObjectUtil.toKObjectKey(path));
        }
        return result;
    }

    public synchronized SeekableByteChannel newByteChannel(final Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        final SeekableByteChannel byteChannel = super.newByteChannel(path, options, attrs);
        return new SeekableByteChannel(){

            public long position() throws IOException {
                return byteChannel.position();
            }

            public SeekableByteChannel position(long newPosition) throws IOException {
                return byteChannel.position(newPosition);
            }

            public long size() throws IOException {
                return byteChannel.size();
            }

            public SeekableByteChannel truncate(long size) throws IOException {
                return byteChannel.truncate(size);
            }

            public int read(ByteBuffer dst) throws java.io.IOException {
                return byteChannel.read(dst);
            }

            public int write(ByteBuffer src) throws java.io.IOException {
                return byteChannel.write(src);
            }

            public boolean isOpen() {
                return byteChannel.isOpen();
            }

            public void close() throws java.io.IOException {
                byteChannel.close();
                for (Class view : IOServiceIndexedImpl.this.views) {
                    IOServiceIndexedImpl.super.getFileAttributeView(path, view);
                }
                FileAttribute[] allAttrs = IOServiceIndexedImpl.this.convert(IOServiceIndexedImpl.this.readAttributes(path));
                IOServiceIndexedImpl.this.indexEngine.index(KObjectUtil.toKObject(path, allAttrs));
            }
        };
    }

    public synchronized Path copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        Path result = super.copy(source, target, options);
        Properties properties = new Properties();
        if (this.exists(DotFileUtils.dot((Path)target))) {
            properties.load(this.newInputStream(DotFileUtils.dot((Path)target), new OpenOption[0]));
        }
        this.indexEngine.index(KObjectUtil.toKObject(target, this.convert((Map)properties)));
        return result;
    }

    public synchronized Path move(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        Path result = super.move(source, target, options);
        this.indexEngine.rename(KObjectUtil.toKObjectKey(source), KObjectUtil.toKObjectKey(target));
        return result;
    }

    private void indexIfFresh(FileSystem fs) {
        if (this.indexEngine.freshIndex() && !this.indexedFSs.contains(fs)) {
            this.index(fs);
        }
    }

    private Path index(Path path) {
        for (Class<? extends FileAttributeView> view : this.views) {
            this.getFileAttributeView(path, view);
        }
        FileAttribute[] allAttrs = this.convert(this.readAttributes(path));
        this.indexEngine.index(KObjectUtil.toKObject(path, allAttrs));
        return path;
    }

    public Path write(Path path, byte[] bytes, OpenOption ... options) throws IOException, UnsupportedOperationException, SecurityException {
        return this.index(super.write(path, bytes, options));
    }

    public Path write(Path path, byte[] bytes, Map<String, ?> attrs, OpenOption ... options) throws IOException, UnsupportedOperationException, SecurityException {
        return this.index(super.write(path, bytes, attrs, options));
    }

    public Path write(Path path, byte[] bytes, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.index(super.write(path, bytes, options, attrs));
    }

    public Path write(Path path, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        return this.index(super.write(path, lines, cs, options));
    }

    public Path write(Path path, String content, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.index(super.write(path, content, options));
    }

    public Path write(Path path, String content, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.index(super.write(path, content, cs, options));
    }

    public Path write(Path path, String content, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.index(super.write(path, content, options, attrs));
    }

    public Path write(Path path, String content, Charset cs, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.index(super.write(path, content, cs, options, attrs));
    }

    public Path write(Path path, String content, Map<String, ?> attrs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.index(super.write(path, content, attrs, options));
    }

    public Path write(Path path, String content, Charset cs, Map<String, ?> attrs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.index(super.write(path, content, cs, attrs, options));
    }

    public OutputStream newOutputStream(final Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        final OutputStream out = super.newOutputStream(path, options);
        return new OutputStream(){

            @Override
            public void write(int b) throws java.io.IOException {
                out.write(b);
            }

            @Override
            public void close() throws java.io.IOException {
                out.close();
                IOServiceIndexedImpl.this.index(path);
            }
        };
    }

    public BufferedWriter newBufferedWriter(final Path path, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        return new BufferedWriter(super.newBufferedWriter(path, cs, options)){

            @Override
            public void close() throws java.io.IOException {
                super.close();
                IOServiceIndexedImpl.this.index(path);
            }
        };
    }

    public Path createFile(Path path, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return this.index(super.createFile(path, attrs));
    }

    public Path setAttributes(Path path, FileAttribute<?> ... attrs) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        return this.index(super.setAttributes(path, attrs));
    }

    public Path setAttributes(Path path, Map<String, Object> attrs) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        return this.index(super.setAttributes(path, attrs));
    }

    public Path setAttribute(Path path, String attribute, Object value) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        return this.index(super.setAttribute(path, attribute, value));
    }

    private void index(FileSystem fs) {
        this.indexedFSs.add(fs);
        this.batchIndex.runAsync(fs);
    }
}

