/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.io;

import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.FileVisitResult;
import org.kie.commons.java.nio.file.FileVisitor;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.SimpleFileVisitor;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributes;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.commons.java.nio.file.attribute.FileAttributeView;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.kieora.engine.MetaIndexEngine;
import org.kie.kieora.io.KObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(BatchIndex.class);
    private final MetaIndexEngine indexEngine;
    private final IOService ioService;
    private final Class<? extends FileAttributeView>[] views;

    public BatchIndex(MetaIndexEngine indexEngine, IOService ioService, Class<? extends FileAttributeView> ... views) {
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
        this.views = views;
    }

    public void runAsync(final FileSystem fs) {
        new Thread(){

            @Override
            public void run() {
                for (Path root : fs.getRootDirectories()) {
                    BatchIndex.this.run(root);
                }
            }
        }.start();
    }

    public void runAsync(final Path root) {
        new Thread(){

            @Override
            public void run() {
                BatchIndex.this.run(root);
            }
        }.start();
    }

    public void run(Path root) {
        try {
            this.indexEngine.startBatchMode();
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)root)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    PortablePreconditions.checkNotNull((String)"file", (Object)file);
                    PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                    if (!file.getFileName().toString().startsWith(".")) {
                        for (Class view : BatchIndex.this.views) {
                            BatchIndex.this.ioService.getFileAttributeView(file, view);
                        }
                        FileAttribute[] allAttrs = BatchIndex.this.ioService.convert(BatchIndex.this.ioService.readAttributes(file));
                        BatchIndex.this.indexEngine.index(KObjectUtil.toKObject(file, allAttrs));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            this.indexEngine.commit();
        }
        catch (IllegalStateException ex) {
            LOG.error("Index fails - Index has an invalid state. [@" + root.getFileSystem().toString() + "]", (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Index fails. [@" + root.getFileSystem().toString() + "]", (Throwable)ex);
        }
    }

    public void dispose() {
        this.indexEngine.dispose();
    }
}

