/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.io;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.kie.commons.java.nio.base.FileSystemId;
import org.kie.commons.java.nio.base.SegmentedPath;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.kieora.model.KObject;
import org.kie.kieora.model.KObjectKey;
import org.kie.kieora.model.KProperty;
import org.kie.kieora.model.schema.MetaType;

public final class KObjectUtil {
    private static final MessageDigest DIGEST;
    private static final MetaType META_TYPE;

    private KObjectUtil() {
    }

    public static KObjectKey toKObjectKey(final Path path) {
        return new KObjectKey(){

            public String getId() {
                return KObjectUtil.sha1(this.getType().getName() + "|" + this.getKey());
            }

            public MetaType getType() {
                return META_TYPE;
            }

            public String getClusterId() {
                return ((FileSystemId)path.getFileSystem()).id();
            }

            public String getSegmentId() {
                return ((SegmentedPath)path).getSegmentId();
            }

            public String getKey() {
                return path.toUri().toString();
            }
        };
    }

    public static KObject toKObject(final Path path, final FileAttribute<?> ... attrs) {
        return new KObject(){

            public String getId() {
                return KObjectUtil.sha1(this.getType().getName() + "|" + this.getKey());
            }

            public MetaType getType() {
                return META_TYPE;
            }

            public String getClusterId() {
                return ((FileSystemId)path.getFileSystem()).id();
            }

            public String getSegmentId() {
                return ((SegmentedPath)path).getSegmentId();
            }

            public String getKey() {
                return path.toUri().toString();
            }

            public Iterable<KProperty<?>> getProperties() {
                return new ArrayList<KProperty<?>>(attrs.length){
                    {
                        for (final FileAttribute attr : attrs) {
                            this.add(new KProperty<Object>(){

                                public String getName() {
                                    return attr.name();
                                }

                                public Object getValue() {
                                    return attr.value();
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                        }
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "filename";
                            }

                            public String getValue() {
                                if (path.getFileName() == null) {
                                    return "/";
                                }
                                return path.getFileName().toString();
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "extension";
                            }

                            public String getValue() {
                                if (path.getFileName() == null) {
                                    return "";
                                }
                                return FilenameUtils.getExtension((String)path.getFileName().toString());
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "basename";
                            }

                            public String getValue() {
                                if (path.getFileName() == null) {
                                    return "";
                                }
                                return FilenameUtils.getBaseName((String)path.getFileName().toString());
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                    }
                };
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("KObject{, key='" + this.getKey() + '\'' + ", id='" + this.getId() + '\'' + ", type=" + this.getType() + ", clusterId='" + this.getClusterId() + '\'' + ", segmentId='" + this.getSegmentId() + '\'');
                for (KProperty<?> xproperty : this.getProperties()) {
                    sb.append(", " + xproperty.getName() + "='" + xproperty.getValue() + '\'');
                }
                sb.append('}');
                return sb.toString();
            }
        };
    }

    private static String sha1(String input) {
        if (input == null || input.trim().length() == 0) {
            return "--";
        }
        return Base64.encodeBase64String((byte[])DIGEST.digest(input.getBytes()));
    }

    static {
        try {
            DIGEST = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        META_TYPE = new MetaType(){

            public String getName() {
                return Path.class.getName();
            }
        };
    }
}

